/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Dimension;
import com.sqlapp.data.schemas.DimensionHierarchyLevelCollection;
import com.sqlapp.data.schemas.DimensionLevel;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.UnOrdered;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class DimensionHierarchyLevel
extends AbstractNamedObject<DimensionHierarchyLevel>
implements HasParent<DimensionHierarchyLevelCollection>,
UnOrdered {
    private static final long serialVersionUID = -766487951195992327L;
    private DimensionLevel level;

    protected DimensionHierarchyLevel() {
    }

    public DimensionHierarchyLevel(String name) {
        this.setName(name);
    }

    @Override
    protected Supplier<DimensionHierarchyLevel> newInstance() {
        return () -> new DimensionHierarchyLevel();
    }

    @Override
    protected String getSimpleName() {
        return "level";
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof DimensionHierarchyLevel)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public DimensionHierarchyLevelCollection getParent() {
        return (DimensionHierarchyLevelCollection)super.getParent();
    }

    public DimensionLevel getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        if (this.level == null) {
            return null;
        }
        return this.level.getName();
    }

    @Override
    public DimensionHierarchyLevel setName(String levelName) {
        if (levelName == null) {
            this.level = null;
        }
        if (this.level == null) {
            DimensionLevel level;
            this.level = level = new DimensionLevel(levelName);
        } else if (!CommonUtils.eq(this.level.getName(), levelName)) {
            DimensionLevel level;
            this.level = level = new DimensionLevel(levelName);
        }
        return (DimensionHierarchyLevel)this.instance();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void validate() {
        super.validate();
        Dimension dimension = this.getAncestor(Dimension.class);
        if (dimension == null) {
            return;
        }
        if (this.getLevel() == null) {
            return;
        }
        DimensionLevel level = (DimensionLevel)dimension.getLevels().get(this.getLevel().getName());
        if (level != null) {
            this.level = level;
        }
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
    }
}

