/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Dimension;
import com.sqlapp.data.schemas.DimensionHierarchyJoinKeyCollection;
import com.sqlapp.data.schemas.DimensionHierarchyJoinKeyColumnCollection;
import com.sqlapp.data.schemas.DimensionLevel;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LevelNameProperty;
import com.sqlapp.data.schemas.properties.object.DimensionHierarchyJoinKeyColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class DimensionHierarchyJoinKey
extends AbstractDbObject<DimensionHierarchyJoinKey>
implements HasParent<DimensionHierarchyJoinKeyCollection>,
LevelNameProperty<DimensionHierarchyJoinKey>,
DimensionHierarchyJoinKeyColumnsProperty<DimensionLevel> {
    private static final long serialVersionUID = -766487951195992327L;
    private DimensionLevel level;
    private DimensionHierarchyJoinKeyColumnCollection columns = new DimensionHierarchyJoinKeyColumnCollection(this);

    @Override
    protected Supplier<DimensionHierarchyJoinKey> newInstance() {
        return () -> new DimensionHierarchyJoinKey();
    }

    protected DimensionHierarchyJoinKey setColumns(DimensionHierarchyJoinKeyColumnCollection columns) {
        this.columns = columns;
        if (columns != null) {
            columns.setParent(this);
        }
        return (DimensionHierarchyJoinKey)this.instance();
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add((ISchemaProperty)SchemaProperties.LEVEL_NAME, this.getLevelName());
        builder.add((ISchemaProperty)SchemaObjectProperties.DIMENSION_HIERARCHY_JOIN_KEY_COLUMNS, this.getColumns().toString("(", ")"));
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.getColumns())) {
            this.getColumns().writeXml(stax);
        }
        super.writeXmlOptionalValues(stax);
    }

    @Override
    protected String getSimpleName() {
        return "joinKey";
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof DimensionHierarchyJoinKey)) {
            return false;
        }
        DimensionHierarchyJoinKey val = (DimensionHierarchyJoinKey)obj;
        if (!this.equals(SchemaProperties.LEVEL_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.DIMENSION_HIERARCHY_JOIN_KEY_COLUMNS, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public DimensionHierarchyJoinKeyCollection getParent() {
        return (DimensionHierarchyJoinKeyCollection)super.getParent();
    }

    public DimensionLevel getLevel() {
        return this.level;
    }

    @Override
    public String getLevelName() {
        if (this.level == null) {
            return null;
        }
        return this.level.getName();
    }

    public DimensionHierarchyJoinKey setLevel(DimensionLevel level) {
        this.level = level;
        return (DimensionHierarchyJoinKey)this.instance();
    }

    @Override
    public DimensionHierarchyJoinKey setLevelName(String levelName) {
        if (levelName == null) {
            this.level = null;
            return (DimensionHierarchyJoinKey)this.instance();
        }
        if (this.level == null) {
            DimensionLevel level;
            this.level = level = new DimensionLevel(levelName);
        } else if (!CommonUtils.eq(this.level.getName(), levelName)) {
            DimensionLevel level;
            this.level = level = new DimensionLevel(levelName);
        }
        return (DimensionHierarchyJoinKey)this.instance();
    }

    @Override
    public DimensionHierarchyJoinKeyColumnCollection getColumns() {
        return this.columns;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.LEVEL_NAME.getLabel(), this.getLevelName());
    }

    @Override
    protected void validate() {
        super.validate();
        Dimension dimension = this.getAncestor(Dimension.class);
        if (dimension == null) {
            return;
        }
        if (this.getLevel() == null) {
            return;
        }
        DimensionLevel level = (DimensionLevel)dimension.getLevels().get(this.getLevel().getName());
        if (level != null) {
            this.level = level;
        }
    }

    @Override
    public int compareTo(DimensionHierarchyJoinKey o) {
        return 0;
    }
}

