/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.DbInfoEntry;
import com.sqlapp.data.schemas.DbInfoEntryXmlReaderHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.xml.EntryHandler;
import com.sqlapp.util.xml.StaxElementHandler;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

class DbInfoXmlReaderHandler
extends AbstractObjectXmlReaderHandler<DbInfo> {
    @Override
    public String getLocalName() {
        return SchemaProperties.SPECIFICS.getLabel();
    }

    protected DbInfoXmlReaderHandler() {
    }

    @Override
    protected void initializeSetValue() {
        super.initializeSetValue();
        this.registerChild(new DbInfoEntryXmlReaderHandler());
        EntryHandler handler = new EntryHandler();
        this.registerChild(handler);
    }

    @Override
    public void doCallback(StaxReader reader, StaxElementHandler child, String name, Object ownObject, Object childObject) throws XMLStreamException {
        DbInfo dbInfo = (DbInfo)CommonUtils.cast(ownObject);
        if (childObject != null) {
            if (childObject instanceof DbInfoEntry) {
                DbInfoEntry dbInfoEntry = (DbInfoEntry)CommonUtils.cast(childObject);
                dbInfoEntry.getKeyValues().forEach((k, v) -> dbInfo.put((String)k, (String)v));
            } else {
                Map.Entry entry = (Map.Entry)CommonUtils.cast(childObject);
                dbInfo.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    protected DbInfo createNewInstance(Object parentObject) {
        AbstractDbObject obj = null;
        if (parentObject instanceof AbstractDbObject && (obj = (AbstractDbObject)parentObject).getSpecifics() != null) {
            return obj.getSpecifics();
        }
        return new DbInfo();
    }
}

