/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.util.StaxWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;

public interface DbCommonObject<T extends DbCommonObject<?>>
extends Serializable,
Cloneable {
    public boolean equals(Object var1, EqualsHandler var2);

    default public <S> S getAncestor(Class<S> clazz) {
        return this.getAncestor((DbCommonObject<?> obj) -> obj.getClass() == clazz);
    }

    default public <S> S getAncestor(Predicate<DbCommonObject<?>> predicate) {
        if (!(this instanceof HasParent)) {
            return null;
        }
        HasParent hasParent = (HasParent)((Object)this);
        DbCommonObject parent = (DbCommonObject)hasParent.getParent();
        while (parent != null) {
            if (predicate.test(parent)) {
                return (S)parent;
            }
            if (!(parent instanceof HasParent)) {
                return null;
            }
            hasParent = (HasParent)((Object)parent);
            parent = (DbCommonObject)hasParent.getParent();
        }
        return null;
    }

    default public void loadXml(Reader reader) throws XMLStreamException {
        this.loadXml(reader, null);
    }

    public void loadXml(Reader var1, XmlReaderOptions var2) throws XMLStreamException;

    default public void loadXml(InputStream stream) throws XMLStreamException {
        this.loadXml(stream, null);
    }

    public void loadXml(InputStream var1, XmlReaderOptions var2) throws XMLStreamException;

    default public void loadXml(String path) throws XMLStreamException, FileNotFoundException {
        this.loadXml(path, null);
    }

    public void loadXml(String var1, XmlReaderOptions var2) throws XMLStreamException, FileNotFoundException;

    default public void loadXml(File file) throws XMLStreamException, IOException {
        this.loadXml(file, null);
    }

    public void loadXml(File var1, XmlReaderOptions var2) throws XMLStreamException, IOException;

    public void writeXml(String var1) throws XMLStreamException, IOException;

    public void writeXml(File var1) throws XMLStreamException, IOException;

    public void writeXml(OutputStream var1) throws XMLStreamException;

    public void writeXml(Writer var1) throws XMLStreamException;

    public void writeXml(StaxWriter var1) throws XMLStreamException;

    public String toStringSimple();
}

