/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractColumnConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ExpressionProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class CheckConstraint
extends AbstractColumnConstraint<CheckConstraint>
implements ExpressionProperty<CheckConstraint> {
    private static final long serialVersionUID = -3296514394919641856L;
    private String expression = null;
    private static EqualsHandler EQUALS_HANDLER = new IncludeFilterEqualsHandler(SchemaProperties.EXPRESSION.getLabel());

    protected CheckConstraint() {
    }

    @Override
    protected Supplier<Constraint> newInstance() {
        return () -> new CheckConstraint();
    }

    @Override
    public CheckConstraint clone() {
        return (CheckConstraint)super.clone();
    }

    public CheckConstraint(String constraintName, String expression, Column ... columns) {
        super(constraintName, columns);
        this.expression = expression;
    }

    public CheckConstraint(String constraintName, String expression, List<Column> columns) {
        super(constraintName, columns);
        this.expression = expression;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof CheckConstraint)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        CheckConstraint val = (CheckConstraint)obj;
        if (!this.equals(SchemaProperties.EXPRESSION, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        super.toStringDetail(builder);
        builder.add((ISchemaProperty)SchemaProperties.EXPRESSION, this.expression);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.EXPRESSION, (Object)this);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public CheckConstraint setExpression(String expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof CheckConstraint)) {
            return false;
        }
        CheckConstraint con = (CheckConstraint)obj;
        if (!CommonUtils.eq(this.getName(), con.getName()) && this.getParent() != null && con.getParent() != null && (this.getParent().contains(con.getName()) || con.getParent().contains(this.getName()))) {
            return false;
        }
        return this.equals(obj, EQUALS_HANDLER);
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add((ISchemaProperty)SchemaProperties.CATALOG_NAME, this.getCatalogName());
            builder.add((ISchemaProperty)SchemaProperties.SCHEMA_NAME, this.getSchemaName());
        }
        builder.add((ISchemaProperty)SchemaProperties.NAME, this.getName());
        builder.add((ISchemaProperty)SchemaProperties.EXPRESSION, this.getExpression());
        return builder.toString();
    }

    @Override
    protected CheckConstraint instance() {
        return this;
    }

    @Override
    public CheckConstraint setEnable(boolean bool) {
        super.setEnable(bool);
        return this.instance();
    }

    @Override
    public CheckConstraint setDeferrability(Deferrability deferrability) {
        super.setDeferrability(deferrability);
        return this;
    }

    @Override
    public CheckConstraint setDeferrability(String deferrability) {
        super.setDeferrability(deferrability);
        return this;
    }
}

