/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.AbstractBaseDbObjectCollection;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.AssemblyCollection;
import com.sqlapp.data.schemas.CatalogCollection;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.ColumnPrivilegeCollection;
import com.sqlapp.data.schemas.DirectoryCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Mergeable;
import com.sqlapp.data.schemas.ObjectPrivilegeCollection;
import com.sqlapp.data.schemas.PartitionFunctionCollection;
import com.sqlapp.data.schemas.PartitionSchemeCollection;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.PublicDbLinkCollection;
import com.sqlapp.data.schemas.PublicSynonymCollection;
import com.sqlapp.data.schemas.RoleCollection;
import com.sqlapp.data.schemas.RoleMemberCollection;
import com.sqlapp.data.schemas.RolePrivilegeCollection;
import com.sqlapp.data.schemas.RoutinePrivilegeCollection;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.RowIteratorHandlerProperty;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaPrivilegeCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.SettingCollection;
import com.sqlapp.data.schemas.Sortable;
import com.sqlapp.data.schemas.TableSpaceCollection;
import com.sqlapp.data.schemas.UserCollection;
import com.sqlapp.data.schemas.UserPrivilegeCollection;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import com.sqlapp.data.schemas.properties.CaseSensitiveProperty;
import com.sqlapp.data.schemas.properties.CharacterSemanticsProperty;
import com.sqlapp.data.schemas.properties.CharacterSetProperty;
import com.sqlapp.data.schemas.properties.CollationProperty;
import com.sqlapp.data.schemas.properties.ColumnPrivilegesProperty;
import com.sqlapp.data.schemas.properties.DisplayNameProperty;
import com.sqlapp.data.schemas.properties.DisplayRemarksProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.ProductProperties;
import com.sqlapp.data.schemas.properties.RemarksProperty;
import com.sqlapp.data.schemas.properties.SchemaPrivilegesProperty;
import com.sqlapp.data.schemas.properties.object.AssembliesProperty;
import com.sqlapp.data.schemas.properties.object.DirectoriesProperty;
import com.sqlapp.data.schemas.properties.object.ObjectPrivilegesProperty;
import com.sqlapp.data.schemas.properties.object.PartitionFunctionsProperty;
import com.sqlapp.data.schemas.properties.object.PartitionSchemesProperty;
import com.sqlapp.data.schemas.properties.object.PublicDbLinksProperty;
import com.sqlapp.data.schemas.properties.object.PublicSynonymsProperty;
import com.sqlapp.data.schemas.properties.object.RoleMembersProperty;
import com.sqlapp.data.schemas.properties.object.RolePrivilegesProperty;
import com.sqlapp.data.schemas.properties.object.RolesProperty;
import com.sqlapp.data.schemas.properties.object.RoutinePrivilegesProperty;
import com.sqlapp.data.schemas.properties.object.SchemasProperty;
import com.sqlapp.data.schemas.properties.object.SettingsProperty;
import com.sqlapp.data.schemas.properties.object.TableSpacesProperty;
import com.sqlapp.data.schemas.properties.object.UserPrivilegesProperty;
import com.sqlapp.data.schemas.properties.object.UsersProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.StaxWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Catalog
extends AbstractBaseDbObject<Catalog>
implements NameProperty<Catalog>,
DisplayNameProperty<Catalog>,
RemarksProperty<Catalog>,
DisplayRemarksProperty<Catalog>,
CaseSensitiveProperty<Catalog>,
ProductProperties<Catalog>,
CharacterSemanticsProperty<Catalog>,
CharacterSetProperty<Catalog>,
CollationProperty<Catalog>,
Sortable,
Mergeable<Catalog>,
SchemasProperty<Catalog>,
PublicSynonymsProperty<Catalog>,
PublicDbLinksProperty<Catalog>,
UsersProperty<Catalog>,
RolesProperty<Catalog>,
TableSpacesProperty<Catalog>,
DirectoriesProperty<Catalog>,
PartitionFunctionsProperty<Catalog>,
PartitionSchemesProperty<Catalog>,
AssembliesProperty<Catalog>,
ObjectPrivilegesProperty<Catalog>,
RoutinePrivilegesProperty<Catalog>,
UserPrivilegesProperty<Catalog>,
ColumnPrivilegesProperty<Catalog>,
RolePrivilegesProperty<Catalog>,
SchemaPrivilegesProperty<Catalog>,
RoleMembersProperty<Catalog>,
SettingsProperty<Catalog>,
HasParent<CatalogCollection>,
RowIteratorHandlerProperty {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String displayName = null;
    private String displayRemarks = null;
    private String remarks = null;
    private boolean caseSensitive = (Boolean)SchemaProperties.CASE_SENSITIVE.getDefaultValue();
    private CharacterSemantics characterSemantics = null;
    private String characterSet = null;
    private String collation = null;
    private ProductVersionInfo productVersionInfo = null;
    private SchemaCollection schemas = new SchemaCollection(this);
    private PublicSynonymCollection publicSynonyms = new PublicSynonymCollection(this);
    private PublicDbLinkCollection publicDbLinks = new PublicDbLinkCollection(this);
    private UserCollection users = new UserCollection(this);
    private RoleCollection roles = new RoleCollection(this);
    private TableSpaceCollection tableSpaces = new TableSpaceCollection(this);
    private DirectoryCollection directories = new DirectoryCollection(this);
    private PartitionFunctionCollection partitionFunctions = new PartitionFunctionCollection(this);
    private PartitionSchemeCollection partitionSchemes = new PartitionSchemeCollection(this);
    private AssemblyCollection assemblies = new AssemblyCollection(this);
    private ObjectPrivilegeCollection objectPrivileges = new ObjectPrivilegeCollection(this);
    private RoutinePrivilegeCollection routinePrivileges = new RoutinePrivilegeCollection(this);
    private ColumnPrivilegeCollection columnPrivileges = new ColumnPrivilegeCollection(this);
    private UserPrivilegeCollection userPrivileges = new UserPrivilegeCollection(this);
    private RolePrivilegeCollection rolePrivileges = new RolePrivilegeCollection(this);
    private SchemaPrivilegeCollection schemaPrivileges = new SchemaPrivilegeCollection(this);
    private RoleMemberCollection roleMembers = new RoleMemberCollection(this);
    private SettingCollection settings = new SettingCollection(this);
    private Map<String, AbstractDbObjectCollection> objectMap = this.getObjectMap();

    public Catalog() {
    }

    public Catalog(String name) {
        this.name = name;
    }

    @Override
    protected Supplier<Catalog> newInstance() {
        return () -> new Catalog();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Catalog setName(String name) {
        this.name = name;
        return this;
    }

    private Map<String, AbstractDbObjectCollection> getObjectMap() {
        Map<String, AbstractDbObjectCollection> map = CommonUtils.linkedMap();
        Set<ISchemaProperty> schemaProperties = SchemaUtils.getSchemaObjectProperties(this.getClass());
        for (ISchemaProperty schemaProperty : schemaProperties) {
            map.put(schemaProperty.getLabel(), (AbstractDbObjectCollection)schemaProperty.getValue(this));
        }
        return map;
    }

    @Override
    public void cloneProperties(Catalog clone) {
        super.cloneProperties(clone);
        Map<String, AbstractDbObjectCollection> map = clone.getObjectMap();
        for (Map.Entry<String, AbstractDbObjectCollection> entry : this.getObjectMap().entrySet()) {
            map.get(entry.getKey()).clear();
            AbstractBaseDbObjectCollection cc = entry.getValue().clone();
            map.get(entry.getKey()).addAll((Collection)cc);
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Catalog)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Catalog val = (Catalog)obj;
        if (!this.equals(SchemaProperties.NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DISPLAY_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_MAJOR_VERSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_MINOR_VERSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_REVISION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SEMANTICS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SET, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COLLATION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.REMARKS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DISPLAY_REMARKS, val, equalsHandler)) {
            return false;
        }
        for (Map.Entry<String, AbstractDbObjectCollection> entry : this.objectMap.entrySet()) {
            String key = entry.getKey();
            if (this.equals(key, val, entry.getValue(), val.objectMap.get(key), equalsHandler)) continue;
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.NAME.getLabel(), this.getName());
        stax.writeAttribute(SchemaProperties.DISPLAY_NAME.getLabel(), this.getDisplayName());
        stax.writeAttribute(SchemaProperties.PRODUCT_NAME.getLabel(), this.getProductName());
        stax.writeAttribute(SchemaProperties.PRODUCT_MAJOR_VERSION.getLabel(), (Object)this.getProductMajorVersion());
        stax.writeAttribute(SchemaProperties.PRODUCT_MINOR_VERSION.getLabel(), (Object)this.getProductMinorVersion());
        stax.writeAttribute(SchemaProperties.PRODUCT_REVISION.getLabel(), (Object)this.getProductRevision());
        stax.writeAttribute(SchemaProperties.CHARACTER_SEMANTICS.getLabel(), (Object)this.getCharacterSemantics());
        stax.writeAttribute(SchemaProperties.CHARACTER_SET.getLabel(), this.getCharacterSet());
        stax.writeAttribute(SchemaProperties.COLLATION.getLabel(), this.getCollation());
        if (!this.needsEscape(this.getRemarks())) {
            stax.writeAttribute(SchemaProperties.REMARKS.getLabel(), this.getRemarks());
        }
        if (!this.needsEscape(this.getDisplayRemarks())) {
            stax.writeAttribute(SchemaProperties.DISPLAY_REMARKS.getLabel(), this.getDisplayRemarks());
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        for (Map.Entry<String, AbstractDbObjectCollection> entry : this.objectMap.entrySet()) {
            AbstractDbObjectCollection list = entry.getValue();
            if (CommonUtils.isEmpty(list)) continue;
            list.writeXml(stax);
        }
        if (this.needsEscape(this.getRemarks())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.REMARKS.getLabel(), this.getRemarks());
        }
        if (this.needsEscape(this.getDisplayRemarks())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.DISPLAY_REMARKS.getLabel(), this.getDisplayRemarks());
        }
        super.writeXmlOptionalValues(stax);
    }

    @Override
    public CharacterSemantics getCharacterSemantics() {
        return this.characterSemantics;
    }

    @Override
    public Catalog setCharacterSemantics(CharacterSemantics characterSemantics) {
        this.characterSemantics = characterSemantics;
        return this;
    }

    @Override
    public String getCollation() {
        return this.collation;
    }

    @Override
    public Catalog setCollation(String collation) {
        this.collation = collation;
        return this;
    }

    protected ProductVersionInfo getProductVersionInfo() {
        if (this.productVersionInfo == null) {
            this.productVersionInfo = new ProductVersionInfo();
        }
        return this.productVersionInfo;
    }

    protected void setProductVersionInfo(ProductVersionInfo productVersionInfo) {
        this.productVersionInfo = productVersionInfo;
    }

    @Override
    public String getProductName() {
        return this.getProductVersionInfo().getName();
    }

    @Override
    public Catalog setProductName(String dbProductName) {
        this.getProductVersionInfo().setName(dbProductName);
        return (Catalog)this.instance();
    }

    @Override
    public Integer getProductMajorVersion() {
        return this.getProductVersionInfo().getMajorVersion();
    }

    @Override
    public Catalog setProductMajorVersion(Integer dbMajorVersion) {
        this.getProductVersionInfo().setMajorVersion(dbMajorVersion);
        return (Catalog)this.instance();
    }

    @Override
    public Integer getProductMinorVersion() {
        return this.getProductVersionInfo().getMinorVersion();
    }

    @Override
    public Catalog setProductMinorVersion(Integer dbMinorVersion) {
        this.getProductVersionInfo().setMinorVersion(dbMinorVersion);
        return (Catalog)this.instance();
    }

    @Override
    public Integer getProductRevision() {
        return this.getProductVersionInfo().getRevision();
    }

    @Override
    public Catalog setProductRevision(Integer revision) {
        this.getProductVersionInfo().setRevision(revision);
        return (Catalog)this.instance();
    }

    @Override
    public SchemaCollection getSchemas() {
        return this.schemas;
    }

    @Override
    public UserCollection getUsers() {
        return this.users;
    }

    protected Catalog setSchemas(SchemaCollection schemas) {
        if (this.schemas != null) {
            this.schemas.setParent(this);
        }
        return this;
    }

    protected Catalog setUsers(UserCollection users) {
        this.users = users;
        if (this.users != null) {
            this.users.setParent(this);
        }
        return this;
    }

    @Override
    public RoleCollection getRoles() {
        return this.roles;
    }

    protected Catalog setRoles(RoleCollection roles) {
        this.roles = roles;
        if (this.roles != null) {
            this.roles.setParent(this);
        }
        return this;
    }

    @Override
    public TableSpaceCollection getTableSpaces() {
        return this.tableSpaces;
    }

    protected Catalog setTableSpaces(TableSpaceCollection tableSpaces) {
        this.tableSpaces = tableSpaces;
        if (this.tableSpaces != null) {
            this.tableSpaces.setParent(this);
        }
        return this;
    }

    @Override
    public DirectoryCollection getDirectories() {
        return this.directories;
    }

    protected Catalog setDirectories(DirectoryCollection directories) {
        this.directories = directories;
        if (this.directories != null) {
            this.directories.setParent(this);
        }
        return this;
    }

    @Override
    public PartitionFunctionCollection getPartitionFunctions() {
        return this.partitionFunctions;
    }

    protected Catalog setPartitionFunctions(PartitionFunctionCollection partitionFunctions) {
        this.partitionFunctions = partitionFunctions;
        if (this.partitionFunctions != null) {
            this.partitionFunctions.setParent(this);
        }
        return this;
    }

    @Override
    public PartitionSchemeCollection getPartitionSchemes() {
        return this.partitionSchemes;
    }

    protected Catalog setPartitionSchemes(PartitionSchemeCollection partitionSchemes) {
        this.partitionSchemes = partitionSchemes;
        if (this.partitionSchemes != null) {
            this.partitionSchemes.setParent(this);
        }
        return this;
    }

    @Override
    public AssemblyCollection getAssemblies() {
        return this.assemblies;
    }

    protected Catalog setAssemblies(AssemblyCollection assemblies) {
        this.assemblies = assemblies;
        if (this.assemblies != null) {
            this.assemblies.setParent(this);
        }
        return this;
    }

    @Override
    public ObjectPrivilegeCollection getObjectPrivileges() {
        return this.objectPrivileges;
    }

    protected Catalog setObjectPrivileges(ObjectPrivilegeCollection objectPrivileges) {
        this.objectPrivileges = objectPrivileges;
        if (this.objectPrivileges != null) {
            this.objectPrivileges.setParent(this);
        }
        return this;
    }

    @Override
    public RoutinePrivilegeCollection getRoutinePrivileges() {
        return this.routinePrivileges;
    }

    protected Catalog setRoutinePrivileges(RoutinePrivilegeCollection routinePrivileges) {
        this.routinePrivileges = routinePrivileges;
        if (this.routinePrivileges != null) {
            this.routinePrivileges.setParent(this);
        }
        return this;
    }

    @Override
    public ColumnPrivilegeCollection getColumnPrivileges() {
        return this.columnPrivileges;
    }

    protected Catalog setColumnPrivileges(ColumnPrivilegeCollection columnPrivileges) {
        this.columnPrivileges = columnPrivileges;
        if (this.columnPrivileges != null) {
            this.columnPrivileges.setParent(this);
        }
        return this;
    }

    @Override
    public PublicSynonymCollection getPublicSynonyms() {
        return this.publicSynonyms;
    }

    protected Catalog setPublicSynonyms(PublicSynonymCollection publicSynonyms) {
        this.publicSynonyms = publicSynonyms;
        if (this.publicSynonyms != null) {
            this.publicSynonyms.setParent(this);
        }
        return (Catalog)this.instance();
    }

    @Override
    public PublicDbLinkCollection getPublicDbLinks() {
        return this.publicDbLinks;
    }

    protected Catalog setPublicDbLinks(PublicDbLinkCollection publicDbLinks) {
        this.publicDbLinks = publicDbLinks;
        if (this.publicDbLinks != null) {
            this.publicDbLinks.setParent(this);
        }
        return (Catalog)this.instance();
    }

    @Override
    public UserPrivilegeCollection getUserPrivileges() {
        return this.userPrivileges;
    }

    protected Catalog setUserPrivileges(UserPrivilegeCollection userPrivileges) {
        this.userPrivileges = userPrivileges;
        if (this.userPrivileges != null) {
            this.userPrivileges.setParent(this);
        }
        return this;
    }

    @Override
    public SchemaPrivilegeCollection getSchemaPrivileges() {
        return this.schemaPrivileges;
    }

    @Override
    public RolePrivilegeCollection getRolePrivileges() {
        return this.rolePrivileges;
    }

    protected Catalog setRolePrivileges(RolePrivilegeCollection rolePrivileges) {
        this.rolePrivileges = rolePrivileges;
        if (this.rolePrivileges != null) {
            this.rolePrivileges.setParent(this);
        }
        return this;
    }

    protected Catalog setSchemaPrivileges(SchemaPrivilegeCollection schemaPrivileges) {
        this.schemaPrivileges = schemaPrivileges;
        if (this.schemaPrivileges != null) {
            this.schemaPrivileges.setParent(this);
        }
        return this;
    }

    @Override
    public RoleMemberCollection getRoleMembers() {
        return this.roleMembers;
    }

    protected Catalog setRoleMembers(RoleMemberCollection roleMembers) {
        this.roleMembers = roleMembers;
        if (this.roleMembers != null) {
            this.roleMembers.setParent(this);
        }
        return this;
    }

    @Override
    public SettingCollection getSettings() {
        return this.settings;
    }

    protected Catalog setSettings(SettingCollection settings) {
        this.settings = settings;
        if (this.settings != null) {
            this.settings.setParent(this);
        }
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        for (Schema schema : this.getSchemas()) {
            schema.validate();
        }
    }

    @Override
    public void sort() {
        for (Map.Entry<String, AbstractDbObjectCollection> entry : this.objectMap.entrySet()) {
            if (!(entry.getValue() instanceof Sortable)) continue;
            Sortable sortable = entry.getValue();
            sortable.sort();
        }
    }

    public void sort(Comparator comparator) {
        for (Map.Entry<String, AbstractDbObjectCollection> entry : this.objectMap.entrySet()) {
            if (!(entry.getValue() instanceof Sortable)) continue;
            Sortable sortable = entry.getValue();
            sortable.sort(comparator);
        }
    }

    @Override
    public int compareTo(Catalog o) {
        if (o == null) {
            return 1;
        }
        return CommonUtils.compare((Comparable)((Object)this.getName()), (Object)o.getName());
    }

    @Override
    public void setRowIteratorHandler(RowIteratorHandler rowIteratorHandler) {
        this.getSchemas().setRowIteratorHandler(rowIteratorHandler);
    }

    public void setAddDbObjectFilter(AddDbObjectPredicate addDbObjectFilter) {
        this.getSchemas().setAddDbObjectPredicate(addDbObjectFilter);
        for (Map.Entry<String, AbstractDbObjectCollection> entry : this.objectMap.entrySet()) {
            AbstractDbObjectCollection target = entry.getValue();
            target.setAddDbObjectPredicate(addDbObjectFilter);
        }
    }

    @Override
    public void merge(Catalog obj) {
        Map<String, AbstractDbObjectCollection> myMap = this.getObjectMap();
        Map<String, AbstractDbObjectCollection> objMap = obj.getObjectMap();
        for (Map.Entry<String, AbstractDbObjectCollection> entry : objMap.entrySet()) {
            AbstractDbObjectCollection c = myMap.get(entry.getKey());
            c.addAll((Collection)entry.getValue());
            c.sort();
        }
    }

    @Override
    public CatalogCollection getParent() {
        return (CatalogCollection)super.getParent();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public Catalog setCaseSensitive(boolean value) {
        this.caseSensitive = value;
        return (Catalog)this.instance();
    }

    @Override
    public String getDisplayRemarks() {
        return this.displayRemarks;
    }

    @Override
    public Catalog setDisplayRemarks(String value) {
        this.displayRemarks = value;
        return (Catalog)this.instance();
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public Catalog setRemarks(String value) {
        this.remarks = value;
        return (Catalog)this.instance();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Catalog setDisplayName(String value) {
        this.displayName = value;
        return (Catalog)this.instance();
    }

    @Override
    public String getCharacterSet() {
        return this.characterSet;
    }

    @Override
    public Catalog setCharacterSet(String value) {
        this.characterSet = value;
        return (Catalog)this.instance();
    }

    @Override
    public Dialect getDialect() {
        Dialect dialect = (Dialect)SimpleBeanUtils.getField(this, "dialect");
        if (dialect == null && this.getProductVersionInfo() != null) {
            dialect = this.getProductVersionInfo().toDialect();
            this.setDialect(dialect);
        }
        return dialect;
    }

    @Override
    public Catalog setDialect(Dialect dialect) {
        SimpleBeanUtils.setField(this, "dialect", dialect);
        return this;
    }
}

