/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObjectCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.NamedArgumentCollection;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.SavepointLevel;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SqlDataAccess;
import com.sqlapp.data.schemas.SqlSecurity;
import com.sqlapp.data.schemas.properties.DeterministicProperty;
import com.sqlapp.data.schemas.properties.ExecuteAsProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.MaxDynamicResultSetsProperty;
import com.sqlapp.data.schemas.properties.ParallelProperty;
import com.sqlapp.data.schemas.properties.SavepointLevelProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.data.schemas.properties.SqlDataAccessProperty;
import com.sqlapp.data.schemas.properties.SqlSecurityProperty;
import com.sqlapp.data.schemas.properties.object.ArgumentsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

public abstract class ArgumentRoutine<T extends ArgumentRoutine<T>>
extends Routine<T>
implements ExecuteAsProperty<T>,
SpecificNameProperty<T>,
DeterministicProperty<T>,
ParallelProperty<T>,
SqlDataAccessProperty<T>,
SqlSecurityProperty<T>,
SavepointLevelProperty<T>,
MaxDynamicResultSetsProperty<T>,
ArgumentsProperty<T> {
    private static final long serialVersionUID = 8421121636119616875L;
    protected NamedArgumentCollection<T> arguments = new NamedArgumentCollection(this);
    private Boolean deterministic = null;
    private Boolean parallel = null;
    private SqlDataAccess sqlDataAccess = null;
    private SqlSecurity sqlSecurity = null;
    private String executeAs = null;
    private SavepointLevel savepointLevel = null;
    private Integer maxDynamicResultSets = null;

    protected ArgumentRoutine() {
    }

    protected ArgumentRoutine(String name) {
        super(name);
    }

    public ArgumentRoutine(String name, String specificName) {
        super(name, specificName);
    }

    @Override
    public NamedArgumentCollection<T> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ArgumentRoutine)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        ArgumentRoutine val = (ArgumentRoutine)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.DETERMINISTIC, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PARALLEL, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SQL_DATA_ACCESS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SQL_SECURITY, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.EXECUTE_AS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SAVEPOINT_LEVEL, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MAX_DYNAMIC_RESULT_SETS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.ARGUMENTS, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        super.toStringDetail(builder);
        builder.add((ISchemaProperty)SchemaProperties.DETERMINISTIC, (Object)this.getDeterministic());
        builder.add((ISchemaProperty)SchemaProperties.PARALLEL, (Object)this.getParallel());
        builder.add((ISchemaProperty)SchemaProperties.SQL_DATA_ACCESS, (Object)this.getSqlDataAccess());
        builder.add((ISchemaProperty)SchemaProperties.SQL_SECURITY, (Object)this.getSqlSecurity());
        builder.add((ISchemaProperty)SchemaProperties.EXECUTE_AS, this.getExecuteAs());
        builder.add((ISchemaProperty)SchemaProperties.SAVEPOINT_LEVEL, (Object)this.getSavepointLevel());
        builder.add((ISchemaProperty)SchemaProperties.MAX_DYNAMIC_RESULT_SETS, (Object)this.getMaxDynamicResultSets());
        builder.add((ISchemaProperty)SchemaObjectProperties.ARGUMENTS, this.getArguments());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DETERMINISTIC.getLabel(), (Object)this.getDeterministic());
        stax.writeAttribute(SchemaProperties.PARALLEL.getLabel(), (Object)this.getParallel());
        stax.writeAttribute(SchemaProperties.SQL_DATA_ACCESS.getLabel(), (Object)this.getSqlDataAccess());
        stax.writeAttribute(SchemaProperties.SQL_SECURITY.getLabel(), (Object)this.getSqlSecurity());
        stax.writeAttribute(SchemaProperties.EXECUTE_AS.getLabel(), this.getExecuteAs());
        stax.writeAttribute(SchemaProperties.SAVEPOINT_LEVEL.getLabel(), (Object)this.getSavepointLevel());
        stax.writeAttribute(SchemaProperties.MAX_DYNAMIC_RESULT_SETS.getLabel(), (Object)this.getMaxDynamicResultSets());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getArguments())) {
            this.getArguments().writeXml(stax);
        }
    }

    @Override
    protected void renewParent() {
        if (this.getParent() != null && this.getParent() instanceof AbstractBaseDbObjectCollection) {
            ((AbstractBaseDbObjectCollection)this.getParent()).renew();
        }
    }

    @Override
    public Boolean getDeterministic() {
        return this.deterministic;
    }

    @Override
    public T setDeterministic(Boolean deterministic) {
        this.deterministic = deterministic;
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public Boolean getParallel() {
        return this.parallel;
    }

    @Override
    public T setParallel(Boolean parallel) {
        this.parallel = parallel;
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public SqlDataAccess getSqlDataAccess() {
        return this.sqlDataAccess;
    }

    @Override
    public T setSqlDataAccess(SqlDataAccess sqlDataAccess) {
        this.sqlDataAccess = sqlDataAccess;
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public SqlSecurity getSqlSecurity() {
        return this.sqlSecurity;
    }

    @Override
    public T setSqlSecurity(SqlSecurity sqlSecurity) {
        this.sqlSecurity = sqlSecurity;
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public String getExecuteAs() {
        return this.executeAs;
    }

    @Override
    public T setExecuteAs(String executeAs) {
        SqlSecurity sqlSecurity;
        this.executeAs = executeAs;
        if (this.executeAs != null && (sqlSecurity = SqlSecurity.parse(executeAs)) != null) {
            this.setSqlSecurity(sqlSecurity);
        }
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public SavepointLevel getSavepointLevel() {
        return this.savepointLevel;
    }

    @Override
    public T setSavepointLevel(SavepointLevel savepointLevel) {
        this.savepointLevel = savepointLevel;
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public Integer getMaxDynamicResultSets() {
        return this.maxDynamicResultSets;
    }

    @Override
    public T setMaxDynamicResultSets(Number maxDynamicResultSets) {
        if (maxDynamicResultSets != null) {
            this.setMaxDynamicResultSets(maxDynamicResultSets.intValue());
        } else {
            this.maxDynamicResultSets = null;
        }
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    public T setMaxDynamicResultSets(int maxDynamicResultSets) {
        this.maxDynamicResultSets = maxDynamicResultSets;
        return (T)((ArgumentRoutine)this.instance());
    }

    @Override
    protected void validate() {
        this.arguments.validate();
    }
}

