/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.xml.AbstractStaxElementHandler;
import com.sqlapp.util.xml.EmptyTextSkipHandler;
import com.sqlapp.util.xml.NotEmptyTextHandler;
import com.sqlapp.util.xml.SetValue;
import com.sqlapp.util.xml.StaxElementHandler;
import com.sqlapp.util.xml.TransparentHandler;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

abstract class AbstractObjectXmlReaderHandler<T>
extends AbstractStaxElementHandler {
    protected Map<String, SetValue<T, ?>> setValueMap = CommonUtils.upperMap();
    private Supplier<T> supplier;
    private XmlReaderOptions readerOptions = new XmlReaderOptions();

    protected AbstractObjectXmlReaderHandler() {
        this.initializeSetValue();
        this.registerChild(new EmptyTextSkipHandler());
    }

    protected AbstractObjectXmlReaderHandler(Supplier<T> supplier) {
        this.supplier = supplier;
        this.initializeSetValue();
        this.registerChild(new EmptyTextSkipHandler());
    }

    protected void initializeSetValue() {
    }

    protected T createNewInstance() {
        return this.supplier.get();
    }

    protected void register(String name, SetValue<T, ?> setValue) {
        this.setValueMap.put(name, setValue);
    }

    protected void registerTextHandler(String name, SetValue<T, ?> setValue) {
        this.setValueMap.put(name, setValue);
        this.registerTransparent(name, new NotEmptyTextHandler());
    }

    protected void registerTextHandler(ISchemaProperty schemaProperty) {
        this.setValueMap.put(schemaProperty.getLabel(), (target, name, value) -> schemaProperty.setValue(target, value));
        this.registerTransparent(schemaProperty.getLabel(), new NotEmptyTextHandler());
    }

    public XmlReaderOptions getReaderOptions() {
        if (this.getParent() instanceof AbstractObjectXmlReaderHandler) {
            return ((AbstractObjectXmlReaderHandler)this.getParent()).getReaderOptions();
        }
        return this.readerOptions;
    }

    public void setReaderOptions(XmlReaderOptions readerOptions) {
        if (readerOptions != null) {
            this.readerOptions = readerOptions;
        }
    }

    protected boolean isDbObject(Class<?> clazz) {
        if (DbInfo.class.equals(clazz)) {
            return true;
        }
        if (DbCommonObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz.isArray() && DbCommonObject.class.isAssignableFrom(clazz.getComponentType());
    }

    protected void registerTransparent(final String localName, StaxElementHandler ... childs) {
        TransparentHandler elementHandler = new TransparentHandler(childs){

            @Override
            public String getLocalName() {
                return localName;
            }
        };
        this.registerChild(elementHandler);
    }

    protected void setAlias(String name, String alias) {
        SetValue<T, ?> setValue = this.setValueMap.get(name);
        if (setValue != null) {
            this.register(alias, setValue);
        }
    }

    @Override
    protected void doHandle(StaxReader reader, Object parentObject) throws XMLStreamException {
        T obj = null;
        obj = parentObject instanceof ChildObjectHolder ? (T)((ChildObjectHolder)parentObject).getValue() : (T)this.createNewInstance(parentObject);
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                Map<String, String> map = this.getAttributeMap(reader);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.setValue(obj, entry.getKey(), entry.getValue());
                }
                reader.next();
            }
            if (this.match(reader)) {
                reader.next();
                break;
            }
            this.callChilds(reader, obj);
        }
        this.finishDoHandle(reader, parentObject, obj);
        this.callParent(reader, this.getLocalName(), parentObject, obj);
    }

    protected void finishDoHandle(StaxReader reader, Object parentObject, T ownObject) {
    }

    protected abstract T createNewInstance(Object var1);

    protected void setValue(T obj, String key, Object value) throws XMLStreamException {
        SetValue setValue = (SetValue)CommonUtils.cast(this.setValueMap.get(key));
        if (setValue != null && value != null) {
            setValue.setValue(obj, key, value);
        }
    }

    @Override
    protected void doCallback(StaxReader reader, StaxElementHandler child, String name, Object ownObject, Object childObject) throws XMLStreamException {
        this.setValue(ownObject, name, childObject);
    }

    static class ChildObjectHolder {
        private final Object value;

        ChildObjectHolder(Object value) {
            this.value = value;
        }

        public <T> T getValue() {
            return (T)this.value;
        }
    }
}

