/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractPrivilege;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ObjectNameProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

abstract class AbstractObjectPrivilege<T extends AbstractObjectPrivilege<T>>
extends AbstractPrivilege<T>
implements SchemaNameProperty<T>,
SpecificNameProperty<T>,
ObjectNameProperty<T> {
    private static final long serialVersionUID = 1L;
    private String schemaName;
    private String objectName;
    private String specificName;
    private static final EqualsHandler LIKE_EQUALS_HANDLER = new IncludeFilterEqualsHandler(SchemaProperties.SCHEMA_NAME.getLabel(), SchemaProperties.OBJECT_NAME.getLabel(), SchemaProperties.SPECIFIC_NAME.getLabel());

    AbstractObjectPrivilege() {
    }

    @Override
    public String getSpecificName() {
        return this.specificName;
    }

    @Override
    public T setSpecificName(String specificName) {
        this.specificName = specificName;
        return (T)((AbstractObjectPrivilege)this.instance());
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public T setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return (T)this;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public T setObjectName(String objectName) {
        this.objectName = objectName;
        return (T)this;
    }

    @Override
    protected void writeAttributeXml(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        stax.writeAttribute(this.getObjectNameLabel(), this.getObjectName());
        if (!CommonUtils.isEmpty(this.getSpecificName()) && !CommonUtils.eq(this.getObjectName(), this.getSpecificName())) {
            stax.writeAttribute(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
    }

    protected abstract void writeValueXml(StaxWriter var1) throws XMLStreamException;

    @Override
    protected void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        builder.add(this.getObjectNameLabel(), this.getObjectName());
        if (!CommonUtils.isEmpty(this.getSpecificName()) && !CommonUtils.eq(this.getObjectName(), this.getSpecificName())) {
            builder.add(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
    }

    protected abstract String getObjectNameLabel();

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof AbstractObjectPrivilege)) {
            return false;
        }
        AbstractObjectPrivilege val = (AbstractObjectPrivilege)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.OBJECT_NAME, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.SPECIFIC_NAME, val, equalsHandler);
    }

    @Override
    public boolean like(Object obj) {
        if (!super.like(obj)) {
            return false;
        }
        return this.equals(obj, LIKE_EQUALS_HANDLER);
    }

    @Override
    public int compareTo(T o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        ret = CommonUtils.compare((Comparable)((Object)this.getSchemaName()), (Object)((AbstractObjectPrivilege)o).getSchemaName());
        if (ret != 0) {
            return ret;
        }
        ret = CommonUtils.compare((Comparable)((Object)this.getObjectName()), (Object)((AbstractObjectPrivilege)o).getObjectName());
        if (ret != 0) {
            return ret;
        }
        ret = CommonUtils.compare((Comparable)((Object)this.getSpecificName()), (Object)((AbstractObjectPrivilege)o).getSpecificName());
        if (ret != 0) {
            return ret;
        }
        return ret;
    }
}

