/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.CatalogNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractDbObject<T extends AbstractDbObject<T>>
extends AbstractBaseDbObject<T>
implements CatalogNameProperty<T> {
    private static final long serialVersionUID = 210101856540540272L;
    private String catalogName = null;

    protected AbstractDbObject() {
    }

    @Override
    protected T instance() {
        return (T)this;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof AbstractDbObject)) {
            return false;
        }
        AbstractDbObject val = (AbstractDbObject)obj;
        return this.equalsCatalogName(val, equalsHandler);
    }

    protected boolean equalsCatalogName(T val, EqualsHandler equalsHandler) {
        if (this instanceof HasParent) {
            HasParent hasParent = (HasParent)((Object)this);
            HasParent valHasParent = (HasParent)val;
            if (hasParent.getParent() == null && valHasParent.getParent() == null && !this.equals(SchemaProperties.CATALOG_NAME, val, equalsHandler)) {
                return false;
            }
        } else if (!this.equals(SchemaProperties.CATALOG_NAME, val, equalsHandler, EqualsUtils.getEqualsSupplier(this.catalogName, ((AbstractDbObject)val).getCatalogName()))) {
            return false;
        }
        return true;
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.CATALOG_NAME, this.getCatalogName());
        builder.add((ISchemaProperty)SchemaProperties.ID, this.getId());
        builder.add((ISchemaProperty)SchemaProperties.SPECIFICS, (Object)this.getSpecifics());
        builder.add((ISchemaProperty)SchemaProperties.STATISTICS, (Object)this.getStatistics());
        builder.add((ISchemaProperty)SchemaProperties.CREATED_AT, (Object)this.getCreatedAt());
        builder.add((ISchemaProperty)SchemaProperties.LAST_ALTERED_AT, (Object)this.getLastAlteredAt());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getCatalogName());
        builder.append(this.getId());
        builder.append(this.getCreatedAt());
        builder.append(this.getLastAlteredAt());
        builder.append(this.getDialect());
        return builder.hashCode();
    }

    @Override
    protected void writeCommonNameAttribute(StaxWriter stax) throws XMLStreamException {
        this.writeCatalogNameAttribute(stax);
    }

    protected void writeCatalogNameAttribute(StaxWriter stax) throws XMLStreamException {
        if (this instanceof HasParent) {
            HasParent hasParent = (HasParent)((Object)this);
            if (hasParent.getParent() == null) {
                stax.writeAttribute(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            }
        } else {
            stax.writeAttribute(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
        }
    }

    @Override
    public String getCatalogName() {
        if (this instanceof HasParent) {
            CatalogNameProperty catalogNameProperty = (CatalogNameProperty)this.getAncestor((DbCommonObject<?> o) -> o instanceof CatalogNameProperty);
            if (catalogNameProperty != null) {
                return catalogNameProperty.getCatalogName();
            }
            Catalog catalog = (Catalog)this.getAncestor((DbCommonObject<?> p) -> p instanceof Catalog);
            if (catalog != null) {
                return catalog.getName();
            }
        }
        return this.catalogName;
    }

    @Override
    public T setCatalogName(String catalogName) {
        this.catalogName = catalogName;
        return (T)this.instance();
    }
}

