/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.StaxWriterUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.object.ColumnArrayProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractColumnConstraint<T extends AbstractColumnConstraint<T>>
extends Constraint
implements ColumnArrayProperty<T> {
    private static final long serialVersionUID = 6581080845961436973L;
    private Column[] columns = null;

    protected AbstractColumnConstraint() {
    }

    protected AbstractColumnConstraint(String constraintName, Column ... columns) {
        super(constraintName);
        this.setColumns(columns);
    }

    protected AbstractColumnConstraint(String constraintName, List<Column> columns) {
        super(constraintName);
        this.setColumns(columns.toArray(new Column[0]));
    }

    public Table getTable() {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            return this.getParent().getParent();
        }
        if (CommonUtils.isEmpty(this.columns)) {
            return null;
        }
        Column column = CommonUtils.first(this.columns);
        if (column == null || column.getParent() == null) {
            return null;
        }
        return column.getParent().getParent();
    }

    @Override
    public Column[] getColumns() {
        if (CommonUtils.isEmpty(this.columns)) {
            return this.columns;
        }
        Column column = CommonUtils.first(this.columns);
        if (column.getParent() == null) {
            this.setParentColumn(this.columns);
        }
        return this.columns;
    }

    protected void setParentColumn(Column[] columns) {
        if (CommonUtils.isEmpty(columns)) {
            return;
        }
        Column column = CommonUtils.first(columns);
        Table table = column.getTable();
        if (this.getParent() != null) {
            table = this.getParent().getTable();
        }
        if (table == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            Column getColumn;
            column = columns[i];
            TableCollection tables = table.getParent();
            if (tables == null || column.getTableName() != null && (table = (Table)tables.get(column.getTableName())) == null || (getColumn = (Column)table.getColumns().get(column.getName())) == null) continue;
            columns[i] = getColumn;
        }
    }

    public void addColumns(Column ... columns) {
        List<Object> list = null;
        list = this.columns == null ? CommonUtils.list() : CommonUtils.list(this.columns);
        CommonUtils.add(list, columns);
        this.setColumns(list);
    }

    public void addColumns(List<Column> columns) {
        List<Object> list = null;
        list = this.columns == null ? CommonUtils.list() : CommonUtils.list(this.columns);
        list.addAll(columns);
        this.setColumns(list);
    }

    @Override
    public T setColumns(Column ... columns) {
        this.setParentColumn(columns);
        this.columns = columns;
        return (T)this;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof AbstractColumnConstraint)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        AbstractColumnConstraint val = (AbstractColumnConstraint)obj;
        return this.equals(SchemaObjectProperties.COLUMN_ARRAY, val, equalsHandler, EqualsUtils.getEqualsSupplier(this.eqColumnName(this.getColumns(), val.getColumns())));
    }

    protected boolean eqColumnName(Column[] columns1, Column[] columns2) {
        if (columns1 == null) {
            return columns2 == null;
        }
        if (columns2 == null) {
            return false;
        }
        if (columns1.length != columns2.length) {
            return false;
        }
        for (int i = 0; i < columns1.length; ++i) {
            if (CommonUtils.eq(columns1[i].getName(), columns2[i].getName())) continue;
            return false;
        }
        return true;
    }

    protected boolean eqColumnName(ReferenceColumnCollection columns1, ReferenceColumnCollection columns2) {
        if (columns1 == null) {
            return columns2 == null;
        }
        if (columns2 == null) {
            return false;
        }
        if (columns1.size() != columns2.size()) {
            return false;
        }
        for (int i = 0; i < columns1.size(); ++i) {
            if (CommonUtils.eq(((ReferenceColumn)columns1.get(i)).getName(), ((ReferenceColumn)columns2.get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTableName() {
        if (this.getTable() != null) {
            return this.getTable().getName();
        }
        return super.getTableName();
    }

    @Override
    protected void cloneProperties(Constraint clone) {
        super.cloneProperties(clone);
        if (this.getColumns() != null) {
            List<Column> columns = CommonUtils.list();
            for (Column column : this.getColumns()) {
                columns.add((Column)column.clone());
            }
            ((AbstractColumnConstraint)clone).setColumns(columns);
        }
    }

    protected void writeColumns(String name, StaxWriter stax, Column ... columns) throws XMLStreamException {
        if (!CommonUtils.isEmpty(columns)) {
            stax.newLine();
            stax.indent();
            stax.writeStartElement(name);
            stax.addIndentLevel(1);
            StaxWriterUtils.writeColumnSimple((StaxWriter)stax, (NameProperty[])columns);
            stax.addIndentLevel(-1);
            stax.newLine();
            stax.indent();
            stax.writeEndElement();
        }
    }

    protected void writeColumns(String name, StaxWriter stax, ReferenceColumnCollection columns) throws XMLStreamException {
        if (!CommonUtils.isEmpty(columns)) {
            stax.newLine();
            stax.indent();
            stax.writeStartElement(name);
            stax.addIndentLevel(1);
            StaxWriterUtils.writeColumnSimple(stax, columns);
            stax.addIndentLevel(-1);
            stax.newLine();
            stax.indent();
            stax.writeEndElement();
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        this.writeColumns(SchemaObjectProperties.COLUMNS.getLabel(), stax, this.getColumns());
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaObjectProperties.COLUMNS, AbstractColumnConstraint.columnNamesToString(this.getColumns()));
        super.toStringDetail(builder);
    }

    protected static String columnNamesToString(Column ... columns) {
        if (columns == null || columns.length == 0) {
            return "";
        }
        SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
        builder.setStart("(").setEnd(")");
        builder.addNames(columns);
        return builder.toString();
    }

    protected static String[] columnNamesArray(Column ... columns) {
        if (columns == null || columns.length == 0) {
            return new String[0];
        }
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].getName();
        }
        return columnNames;
    }

    protected static String getTableName(Column ... columns) {
        if (columns == null || columns.length == 0) {
            return null;
        }
        return CommonUtils.first(columns).getTableName();
    }

    protected static String getSchemaName(Column ... columns) {
        if (columns == null || columns.length == 0) {
            return null;
        }
        return CommonUtils.first(columns).getSchemaName();
    }
}

