/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.AbstractBaseDbObjectCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.xml.AbstractSetValue;
import com.sqlapp.util.xml.StaxElementHandler;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

abstract class AbstractBaseDbObjectXmlReaderHandler<T extends AbstractBaseDbObject<?>>
extends AbstractObjectXmlReaderHandler<T> {
    private boolean setParent = true;
    private final String LOCAL_NAME = ((AbstractBaseDbObject)this.createNewInstance()).getSimpleName();

    protected AbstractBaseDbObjectXmlReaderHandler(Supplier<T> supplier) {
        super(supplier);
    }

    @Override
    protected void initializeSetValue() {
        super.initializeSetValue();
        Object obj = this.createNewInstance();
        Set<ISchemaProperty> properties = SchemaUtils.getAllSchemaProperties(obj.getClass());
        for (final ISchemaProperty prop : properties) {
            List<StaxElementHandler> handlers;
            if (!this.isAutoRegistProp(prop)) continue;
            if (this.isDbObject(prop.getValueClass())) {
                handlers = prop.getXmlHandlers();
                handlers.forEach(h -> this.registerChild((StaxElementHandler)h));
                handlers.stream().filter(h -> h instanceof AbstractBaseDbObjectCollectionXmlReaderHandler).map(h -> (AbstractBaseDbObjectCollectionXmlReaderHandler)h).forEach(h -> h.setInstanceGetter(o -> prop.getValue(o)));
                this.register(prop.getLabel(), new AbstractSetValue<T, Object>(){

                    @Override
                    public void setValue(T target, String name, Object setValue) throws XMLStreamException {
                        prop.setValue(target, setValue);
                    }
                });
                continue;
            }
            this.registerTextHandler(prop);
            handlers = prop.getXmlHandlers();
            if (handlers.isEmpty()) continue;
            this.registerTransparent(prop.getLabel(), handlers.toArray(new StaxElementHandler[0]));
        }
    }

    protected boolean isAutoRegistProp(ISchemaProperty prop) {
        return true;
    }

    protected DbCommonObject<?> toParent(Object parentObject) {
        if (parentObject instanceof DbCommonObject) {
            return (DbCommonObject)parentObject;
        }
        return null;
    }

    @Override
    protected T createNewInstance(Object parentObject) {
        AbstractBaseDbObject result = (AbstractBaseDbObject)this.createNewInstance();
        DbCommonObject<?> parent = this.toParent(parentObject);
        if (parent != null) {
            this.setParent(result, parent);
        }
        return (T)result;
    }

    protected void setParent(T t, DbCommonObject<?> parent) {
        if (this.setParent) {
            ((AbstractBaseDbObject)t).setParent(parent);
        }
    }

    protected AbstractBaseDbObjectXmlReaderHandler<T> setSetParent(boolean setParent) {
        this.setParent = setParent;
        return this;
    }

    @Override
    public String getLocalName() {
        return this.LOCAL_NAME;
    }
}

