/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public class IntervalMonth
extends Interval {
    private static final long serialVersionUID = 4867783820152641027L;

    public IntervalMonth() {
    }

    public IntervalMonth(int months) {
        super(0, months, 0, 0, 0, 0, 0L);
    }

    public static IntervalMonth toMonthType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalMonth result = new IntervalMonth(interval.getMonthsFull());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalMonth parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "YEAR", "MONTH");
        }
        return IntervalMonth.toMonthType(interval);
    }

    @Override
    public IntervalMonth clone() {
        return (IntervalMonth)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getMonthsFull());
        builder.append("");
        return builder.toString();
    }
}

