/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalHourToSecond;
import com.sqlapp.util.CommonUtils;
import java.text.DecimalFormat;

public class IntervalMinuteToSecond
extends IntervalHourToSecond {
    private static final long serialVersionUID = -3792165414712653431L;

    private IntervalMinuteToSecond(int hours, int minutes, int seconds, long nanos) {
        super(hours, minutes, seconds, nanos);
    }

    private IntervalMinuteToSecond(int hours, int minutes, double seconds) {
        super(hours, minutes, seconds);
    }

    private IntervalMinuteToSecond(int hours, int minutes, int seconds) {
        super(hours, minutes, seconds, 0L);
    }

    public IntervalMinuteToSecond(int minutes, int seconds, long nanos) {
        super(0, minutes, seconds, nanos);
    }

    public IntervalMinuteToSecond(int minutes, double seconds) {
        super(0, minutes, seconds);
    }

    public IntervalMinuteToSecond(int minutes, int seconds) {
        super(0, minutes, seconds, 0L);
    }

    public static IntervalMinuteToSecond toMinuteToSecondType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalMinuteToSecond result = new IntervalMinuteToSecond(interval.getMinutes() * 60, interval.getSeconds(), interval.getNanos());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalMinuteToSecond parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "MINUTE", "SECOND");
        }
        return IntervalMinuteToSecond.toMinuteToSecondType(interval);
    }

    @Override
    public IntervalMinuteToSecond clone() {
        return (IntervalMinuteToSecond)super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getMinutesFull());
        builder.append(":");
        if (this.getNanos() > 0) {
            DecimalFormat decimalFormat = secondsFormat;
            synchronized (decimalFormat) {
                double val = (double)this.getNanos() / 1.0E9 + (double)this.getSeconds();
                builder.append(secondsFormat.format(val));
            }
        } else {
            builder.append(this.getSeconds());
        }
        builder.append("");
        return builder.toString();
    }
}

