/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public class IntervalMinute
extends Interval {
    private static final long serialVersionUID = -5794364986820692508L;

    public IntervalMinute() {
    }

    public IntervalMinute(int minutes) {
        super(0, 0, 0, 0, minutes, 0, 0L);
    }

    @Override
    public int getMinutes() {
        return super.getMinutesFull();
    }

    public static IntervalMinute toMinuteType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalMinute result = new IntervalMinute(interval.getMinutesFull());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalMinute parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "MINUTE", "MINUTE");
        }
        return IntervalMinute.toMinuteType(interval);
    }

    @Override
    public IntervalMinute clone() {
        return (IntervalMinute)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getMinutesFull());
        builder.append("");
        return builder.toString();
    }
}

