/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalDayToSecond;
import com.sqlapp.util.CommonUtils;
import java.text.DecimalFormat;

public class IntervalHourToSecond
extends IntervalDayToSecond {
    private static final long serialVersionUID = -7722837328367021543L;

    private IntervalHourToSecond(int days, int hours, int minutes, int seconds, long nanos) {
        super(days, hours, minutes, seconds, nanos);
    }

    public IntervalHourToSecond(int hours, int minutes, int seconds, long nanos) {
        super(0, hours, minutes, seconds, nanos);
    }

    public IntervalHourToSecond(int hours, int minutes, double seconds) {
        super(0, hours, minutes, seconds);
    }

    public IntervalHourToSecond(int hours, int minutes, int seconds) {
        super(0, hours, minutes, seconds, 0L);
    }

    public static IntervalHourToSecond toHourToSecondType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalHourToSecond result = new IntervalHourToSecond(interval.getHoursFull(), interval.getMinutes(), interval.getSeconds(), (long)interval.getNanos());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalHourToSecond parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "HOUR", "SECOND");
        }
        return IntervalHourToSecond.toHourToSecondType(interval);
    }

    @Override
    public IntervalHourToSecond clone() {
        return (IntervalHourToSecond)super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getHoursFull());
        builder.append(":");
        builder.append(this.getMinutes());
        builder.append(":");
        if (this.getNanos() > 0) {
            DecimalFormat decimalFormat = secondsFormat;
            synchronized (decimalFormat) {
                double val = (double)this.getNanos() / 1.0E9 + (double)this.getSeconds();
                builder.append(secondsFormat.format(val));
            }
        } else {
            builder.append(this.getSeconds());
        }
        builder.append("");
        return builder.toString();
    }
}

