/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalHourToSecond;
import com.sqlapp.util.CommonUtils;

public final class IntervalHourToMinute
extends IntervalHourToSecond {
    private static final long serialVersionUID = -8236104654148730695L;

    public IntervalHourToMinute(int hours, int minutes) {
        super(hours, minutes, 0, 0L);
    }

    public static IntervalHourToMinute toHourToMinuteType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalHourToMinute result = new IntervalHourToMinute(interval.getHoursFull(), interval.getMinutes());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalHourToMinute parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "HOUR", "MINUTE");
        }
        return IntervalHourToMinute.toHourToMinuteType(interval);
    }

    @Override
    public void setSeconds(int seconds) {
        super.setSeconds(0);
    }

    @Override
    public void setSeconds(double seconds) {
        super.setSeconds(0);
    }

    @Override
    public void setNanos(int nanos) {
        super.setNanos(0);
    }

    @Override
    public void setNanos(long nanos) {
        super.setNanos(0);
    }

    @Override
    public IntervalHourToMinute clone() {
        return (IntervalHourToMinute)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getHoursFull());
        builder.append(":");
        builder.append(this.getMinutes());
        builder.append("");
        return builder.toString();
    }
}

