/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public class IntervalHour
extends Interval {
    private static final long serialVersionUID = 2517932092799906545L;

    public IntervalHour() {
    }

    public IntervalHour(int hours) {
        super(0, 0, 0, hours, 0, 0, 0L);
    }

    public static IntervalHour toHourType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalHour result = new IntervalHour(interval.getDays() * 24 + interval.getHours());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalHour parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "HOUR", "HOUR");
        }
        return IntervalHour.toHourType(interval);
    }

    @Override
    public int getHours() {
        return super.getHoursFull();
    }

    @Override
    public IntervalHour clone() {
        return (IntervalHour)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getDays() * 24 + this.getHours());
        builder.append("");
        return builder.toString();
    }
}

