/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalDayToMinute;
import com.sqlapp.util.CommonUtils;

public final class IntervalDayToHour
extends IntervalDayToMinute {
    private static final long serialVersionUID = 7033299601565739695L;

    private IntervalDayToHour(int days, int hours, int minutes) {
        super(days, hours, 0);
    }

    public IntervalDayToHour() {
    }

    public IntervalDayToHour(int days, int hours) {
        super(days, hours, 0);
    }

    public static IntervalDayToHour toDayToHourType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalDayToHour result = new IntervalDayToHour(interval.getDays(), interval.getHours());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalDayToHour parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "DAY", "HOUR");
        }
        return IntervalDayToHour.toDayToHourType(interval);
    }

    @Override
    public void setMinutes(int minutes) {
        super.setMinutes(this.truncate(minutes, 60));
    }

    @Override
    public void setMinutes(double minutes) {
        this.setMinutes((int)minutes);
    }

    @Override
    public IntervalDayToHour clone() {
        return (IntervalDayToHour)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getDays());
        builder.append(" ");
        builder.append(this.getHours());
        return builder.toString();
    }
}

