/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public final class IntervalDay
extends Interval {
    private static final long serialVersionUID = 2517932092799906545L;

    public IntervalDay() {
    }

    public IntervalDay(int days) {
        super(0, 0, days, 0, 0, 0, 0L);
    }

    public static IntervalDay toDayType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalDay result = new IntervalDay(interval.getDays());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalDay parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "YEAR", "DAY");
        }
        return IntervalDay.toDayType(interval);
    }

    @Override
    public IntervalDay clone() {
        return (IntervalDay)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getDays());
        builder.append("");
        return builder.toString();
    }
}

