/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.Java8DateUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.Month;
import java.time.MonthDay;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Interval
implements Serializable,
Cloneable,
Comparable<Interval> {
    private static final long serialVersionUID = -5789019381885490073L;
    protected static final DecimalFormat secondsFormat = new DecimalFormat("0.######");
    private boolean positive = true;
    private int months;
    private int seconds;
    private int nanos;
    protected static final int NANO_LIMIT = 1000000000;
    protected static final int SECOND_LIMIT = 60;
    protected static final int MINUTE_LIMIT = 60;
    protected static final int HOUR_LIMIT = 24;
    protected static final int MONTH_LIMIT = 12;
    protected static final int MINUTE_SECONDS = 60;
    protected static final int HOUR_SECONDS = 3600;
    protected static final int HOUR_MINUTES = 60;
    protected static final int DAY_SECONDS = 86400;
    protected static final String TO = "TO";
    protected static final String YEAR = "YEAR";
    protected static final String MONTH = "MONTH";
    protected static final String DAY = "DAY";
    protected static final String HOUR = "HOUR";
    protected static final String MINUTE = "MINUTE";
    protected static final String SECOND = "SECOND";
    private static final String[] UNITS;
    protected static final String YEAR_TO_MONTH;
    protected static final String MONTH_TO_DAY;
    protected static final String YEAR_TO_DAY;
    protected static final String DAY_TO_SECOND;
    protected static final String HOUR_TO_MINUTE;
    protected static final String HOUR_TO_SECOND;
    protected static final String MINUTE_TO_SECOND;
    private static final String MONTH_PIPE_SECOND = "MONTH|DAY|HOUR|MINUTE|SECOND";
    private static final String YEAR_PIPE_SECOND = "YEAR|MONTH|DAY|HOUR|MINUTE|SECOND";
    private static final Pattern INTERVAL_PATTERN;

    protected static String getTypeName(String type1, String type2) {
        return type1 + " TO " + type2;
    }

    public Interval() {
    }

    public Interval(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        this.setValue(years * 12 + months, days * 86400 + hours * 3600 + minutes * 60 + seconds, nanos);
    }

    public Interval(int years, int months, int days, int hours, int minutes, double seconds) {
        this.setValue(years * 12 + months, (double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0 + seconds);
    }

    public Interval(int years, int months, int days, int hours, int minutes, int seconds) {
        this.setValue(years * 12 + months, days * 86400 + hours * 3600 + minutes * 60 + seconds, 0L);
    }

    public Interval scale(int scale) {
        this.positive = scale >= 0;
        int absScale = CommonUtils.abs(scale);
        this.setValue(this.months * absScale, (long)this.seconds * (long)absScale, (long)this.nanos * (long)absScale);
        return this;
    }

    protected void setValue(int months, double seconds) {
        int secondsInt = (int)seconds;
        int nanoInt = (int)((seconds - (double)secondsInt) * 1.0E9);
        this.setValue(months, secondsInt, nanoInt);
    }

    protected void setValue(int months, long seconds, long nanos) {
        months = CommonUtils.abs(months);
        seconds = CommonUtils.abs(seconds);
        long val = (nanos = CommonUtils.abs(nanos)) / 1000000000L;
        if (val > 0L) {
            this.nanos = (int)(nanos % 1000000000L);
            seconds += val;
        } else {
            this.nanos = (int)nanos;
        }
        this.seconds = (int)seconds;
        this.months = months;
    }

    public Timestamp add(Timestamp ts) {
        return this.add(ts, 1);
    }

    public Timestamp add(Timestamp ts, int multiplicity) {
        int nanos = ts.getNanos();
        Calendar cal = Calendar.getInstance();
        cal.setTime(ts);
        cal.set(14, 0);
        cal = this.add(cal, multiplicity);
        Timestamp ret = new Timestamp(cal.getTimeInMillis());
        ret.setTime(cal.getTime().getTime());
        if (this.isPositive()) {
            ts.setNanos(nanos + this.getNanos() * multiplicity);
        } else {
            ret.setNanos(nanos - this.getNanos() * multiplicity);
        }
        return ts;
    }

    public Calendar add(Calendar cal) {
        return this.add(cal, 1);
    }

    public Calendar add(Calendar cal, int multiplicity) {
        Calendar ret = (Calendar)cal.clone();
        if (this.isPositive()) {
            ret.add(14, this.getMilliseconds() * multiplicity);
            ret.add(13, this.getSeconds() * multiplicity);
            ret.add(12, this.getMinutes() * multiplicity);
            ret.add(11, this.getHours() * multiplicity);
            ret.add(5, this.getDays() * multiplicity);
            ret.add(2, this.getMonths() * multiplicity);
            ret.add(1, this.getYears() * multiplicity);
        } else {
            ret.add(14, -this.getMilliseconds() * multiplicity);
            ret.add(13, -this.getSeconds() * multiplicity);
            ret.add(12, -this.getMinutes() * multiplicity);
            ret.add(11, -this.getHours() * multiplicity);
            ret.add(5, -this.getDays() * multiplicity);
            ret.add(2, -this.getMonths() * multiplicity);
            ret.add(1, -this.getYears() * multiplicity);
        }
        return ret;
    }

    public java.util.Date add(java.util.Date date) {
        return this.add(date, 1);
    }

    public java.util.Date add(java.util.Date date, int multiplicity) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal = this.add(cal, multiplicity);
        return cal.getTime();
    }

    public Date add(Date date) {
        return this.add(date, 1);
    }

    public Date add(Date date, int multiplicity) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal = this.add(cal, multiplicity);
        return new Date(cal.getTimeInMillis());
    }

    public Time add(Time time, int multiplicity) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        if (this.isPositive()) {
            cal.add(14, this.getMilliseconds() * multiplicity);
            cal.add(13, this.getSeconds() * multiplicity);
            cal.add(12, this.getMinutes() * multiplicity);
            cal.add(11, this.getHours() * multiplicity);
        } else {
            cal.add(14, -this.getMilliseconds() * multiplicity);
            cal.add(13, -this.getSeconds() * multiplicity);
            cal.add(12, -this.getMinutes() * multiplicity);
            cal.add(11, -this.getHours() * multiplicity);
        }
        return new Time(cal.getTimeInMillis() * (long)multiplicity);
    }

    public Time add(Time time) {
        return this.add(time, 1);
    }

    public <T extends Temporal> T add(T temporal, int multiplicity) {
        T ret = temporal;
        if (this.months != 0) {
            ret = Java8DateUtils.addMonths(ret, this.months * multiplicity);
        }
        if (this.seconds != 0) {
            ret = ret instanceof ChronoLocalDate ? Java8DateUtils.addDays(ret, this.seconds * multiplicity / 24 / 3600) : Java8DateUtils.addSeconds(ret, this.seconds * multiplicity);
        }
        return ret;
    }

    public Month add(Month temporal, int multiplicity) {
        Month ret = temporal;
        if (this.months != 0) {
            ret = Java8DateUtils.addMonths(ret, this.months * multiplicity);
        }
        return ret;
    }

    public MonthDay add(MonthDay temporal, int multiplicity) {
        MonthDay ret = temporal;
        if (this.months != 0) {
            ret = Java8DateUtils.addMonths(ret, this.months * multiplicity);
        }
        if (this.months != 0) {
            ret = Java8DateUtils.addDays(ret, this.getDays() * multiplicity);
        }
        return ret;
    }

    public YearMonth add(YearMonth temporal, int multiplicity) {
        YearMonth ret = temporal;
        if (this.months != 0) {
            ret = Java8DateUtils.addMonths(ret, this.months * multiplicity);
        }
        return ret;
    }

    public <T extends Temporal> T add(T temporal) {
        return this.add(temporal, 1);
    }

    public Month add(Month temporal) {
        return this.add(temporal, 1);
    }

    public YearMonth add(YearMonth temporal) {
        return this.add(temporal, 1);
    }

    public void add(Interval interval) {
        if (this.isPositive()) {
            interval.setYears(this.getYears() + interval.getYears());
            interval.setMonths(interval.getMonths() + this.getMonths());
            interval.setDays(interval.getDays() + this.getDays());
            interval.setHours(interval.getHours() + this.getHours());
            interval.setMinutes(interval.getMinutes() + this.getMinutes());
            interval.setSeconds(interval.getSeconds() + this.getSeconds());
            interval.setNanos(interval.getNanos() + this.getNanos());
        } else {
            interval.setYears(this.getYears() - interval.getYears());
            interval.setMonths(interval.getMonths() - this.getMonths());
            interval.setDays(interval.getDays() - this.getDays());
            interval.setHours(interval.getHours() - this.getHours());
            interval.setMinutes(interval.getMinutes() - this.getMinutes());
            interval.setSeconds(interval.getSeconds() - this.getSeconds());
            interval.setNanos(interval.getNanos() - this.getNanos());
        }
    }

    public static Interval parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        return Interval.parseDetail(val);
    }

    public static boolean isParsable(String val) {
        Matcher mathcer = null;
        String upperVal = val.toUpperCase();
        mathcer = upperVal.startsWith("INTERVAL") ? INTERVAL_PATTERN.matcher(upperVal.substring("INTERVAL".length())) : INTERVAL_PATTERN.matcher(upperVal);
        return mathcer.matches();
    }

    protected static Interval parseDetail(String val) {
        String upperVal = val.toUpperCase();
        Matcher mathcer = null;
        mathcer = upperVal.startsWith("INTERVAL") ? INTERVAL_PATTERN.matcher(upperVal.substring("INTERVAL".length())) : INTERVAL_PATTERN.matcher(upperVal);
        if (!mathcer.matches()) {
            throw CommonUtils.toRe(new ParseException("Interval#parse(" + val + ") fail.", 0));
        }
        int count = 1;
        String matchValue = mathcer.group(count++);
        String firstUnit = mathcer.group(count++);
        String secondUnit = mathcer.group(count++);
        String secondUnit2 = mathcer.group(count++);
        String secondUnit3 = mathcer.group(count++);
        if (CommonUtils.isEmpty(firstUnit)) {
            return null;
        }
        return Interval.parse(matchValue, firstUnit, Interval.getUnit(secondUnit, secondUnit2, secondUnit3));
    }

    private static String getUnit(String ... args) {
        for (String arg : args) {
            if (arg == null || TO.equals(arg)) continue;
            return arg;
        }
        return null;
    }

    protected static Interval parse(String value, String firstUnit, String secondUnit) {
        Interval result = new Interval();
        String matchValue = CommonUtils.trim(CommonUtils.unwrap(CommonUtils.trim(value), '\''));
        if (matchValue.startsWith("-")) {
            result.scale(-1);
        }
        if (!CommonUtils.isEmpty(secondUnit)) {
            String[] tmp = matchValue.split("[- ]");
            String[] splits = null;
            if (CommonUtils.isEmpty(CommonUtils.first(tmp))) {
                splits = new String[tmp.length - 1];
                System.arraycopy(tmp, 1, splits, 0, tmp.length - 1);
            } else {
                splits = tmp;
            }
            int dayPosition = Interval.unitPosition(DAY);
            int hourPosition = dayPosition + 1;
            int firstUnitPosition = Interval.unitPosition(firstUnit);
            int secondUnitPosition = Interval.unitPosition(secondUnit);
            if (dayPosition < firstUnitPosition) {
                String[] timeSplits = CommonUtils.last(splits).split(":");
                for (int i = 0; i < timeSplits.length; ++i) {
                    if (timeSplits[i].contains(".")) {
                        Interval.setValue(result, UNITS[firstUnitPosition], timeSplits[i]);
                    } else {
                        Interval.setValue(result, UNITS[firstUnitPosition], Integer.valueOf(timeSplits[i]));
                    }
                    ++firstUnitPosition;
                }
            } else if (dayPosition < secondUnitPosition) {
                for (int i = splits.length - 2; i >= 0; --i) {
                    Interval.setValue(result, UNITS[dayPosition], Integer.valueOf(splits[i]));
                    --dayPosition;
                }
                String[] timeSplits = CommonUtils.last(splits).split(":");
                for (int i = 0; i < timeSplits.length; ++i) {
                    if (timeSplits[i].contains(".")) {
                        Interval.setValue(result, UNITS[hourPosition], timeSplits[i]);
                    } else {
                        Interval.setValue(result, UNITS[hourPosition], Integer.valueOf(timeSplits[i]));
                    }
                    ++hourPosition;
                }
            } else {
                for (int i = splits.length - 1; i >= 0; --i) {
                    Interval.setValue(result, UNITS[secondUnitPosition], Integer.valueOf(splits[i]));
                    --secondUnitPosition;
                }
            }
        } else if (matchValue.contains(".")) {
            Interval.setValue(result, firstUnit, matchValue);
        } else {
            Interval.setValue(result, firstUnit, Integer.valueOf(matchValue));
        }
        return result;
    }

    protected static void setValue(Interval interval, String unit, String value) {
        if (YEAR.equalsIgnoreCase(unit)) {
            interval.setYears(Double.valueOf(value));
        } else if (MONTH.equalsIgnoreCase(unit)) {
            interval.setMonths(Double.valueOf(value).intValue());
        } else if (DAY.equalsIgnoreCase(unit)) {
            interval.setDays(Double.valueOf(value).intValue());
        } else if (HOUR.equalsIgnoreCase(unit)) {
            interval.setHours(Double.valueOf(value).intValue());
        } else if (MINUTE.equalsIgnoreCase(unit)) {
            interval.setMinutes(Double.valueOf(value).intValue());
        } else if (SECOND.equalsIgnoreCase(unit)) {
            String[] sp = value.split("\\.");
            int sec = Integer.valueOf(sp[0]);
            int nano = Integer.valueOf((sp[1] + "000000000").substring(0, 9));
            interval.setSeconds(sec);
            interval.setNanos(nano);
        }
    }

    private static int unitPosition(String unit) {
        for (int i = 0; i < UNITS.length; ++i) {
            if (!UNITS[i].equalsIgnoreCase(unit)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval val = (Interval)obj;
        if (val.positive != this.positive) {
            return false;
        }
        if (val.months != this.months) {
            return false;
        }
        if (val.seconds != this.seconds) {
            return false;
        }
        return CommonUtils.abs(val.nanos - this.nanos) <= 1;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.positive);
        builder.append(this.months);
        builder.append(this.seconds);
        builder.append(this.nanos);
        return builder.hashCode();
    }

    public Interval clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setValue(Interval interval, String unit, int value) {
        if (YEAR.equalsIgnoreCase(unit)) {
            interval.setYears(value);
        } else if (MONTH.equalsIgnoreCase(unit)) {
            interval.setMonths(value);
        } else if (DAY.equalsIgnoreCase(unit)) {
            interval.setDays(value);
        } else if (HOUR.equalsIgnoreCase(unit)) {
            interval.setHours(value);
        } else if (MINUTE.equalsIgnoreCase(unit)) {
            interval.setMinutes(value);
        } else if (SECOND.equalsIgnoreCase(unit)) {
            interval.setSeconds(value);
        } else {
            interval.setNanos(value);
        }
    }

    public int getYears() {
        return this.months / 12;
    }

    public void setYears(int years) {
        this.setValue(years * 12 + this.getMonths() % 12, this.seconds, this.nanos);
    }

    public void setYears(double years) {
        int calc = (int)(years * 12.0);
        this.setValue(calc, this.seconds, this.nanos);
    }

    public int getMonths() {
        return this.months % 12;
    }

    public int getMonthsFull() {
        return this.months;
    }

    public void setMonths(int months) {
        int calc = 0;
        calc = months > 12 ? months : this.getYears() * 12 + months;
        this.setValue(calc, this.seconds, this.nanos);
    }

    public int getDays() {
        return this.seconds / 86400;
    }

    public void setDays(int days) {
        int calc = days * 86400 + this.getHours() * 3600 + this.getMinutes() * 60 + this.getSeconds();
        this.setValue(this.months, calc, this.nanos);
    }

    public void setDays(double days) {
        double calc = (days - (double)((int)days)) * 24.0;
        if (calc != 0.0) {
            this.setHours(calc);
        }
        this.setDays((int)days);
    }

    public int getHours() {
        return (this.seconds - this.getDays() * 86400) / 3600;
    }

    protected int getHoursFull() {
        return this.seconds / 3600;
    }

    public void setHours(int hours) {
        int calc = 0;
        if (hours > 24) {
            this.setDays(hours / 24);
        }
        calc = this.getDays() * 86400 + hours % 24 * 3600 + this.getMinutes() * 60 + this.getSeconds();
        this.setValue(this.months, calc, this.nanos);
    }

    public void setHours(double hours) {
        double calc = (hours - (double)((int)hours)) * 60.0;
        if (calc != 0.0) {
            this.setMinutes(calc);
        }
        this.setHours((int)hours);
    }

    public int getMinutes() {
        return (this.seconds - this.getDays() * 86400 - this.getHours() * 3600) / 60;
    }

    protected int getMinutesFull() {
        return this.seconds / 60;
    }

    public void setMinutes(int minutes) {
        int calc = 0;
        if (minutes > 60) {
            this.setHours(minutes / 60);
        }
        calc = this.getDays() * 86400 + this.getHours() * 3600 + minutes % 60 * 60 + this.getSeconds();
        this.setValue(this.months, calc, this.nanos);
    }

    public void setMinutes(double minutes) {
        double calc = (minutes - (double)((int)minutes)) * 60.0;
        if (calc != 0.0) {
            this.setSeconds(calc);
        }
        this.setMinutes((int)minutes);
    }

    public int getSeconds() {
        return this.seconds % 60;
    }

    public int getSecondsFull() {
        return this.seconds;
    }

    public double getSecondsAsDouble() {
        double ret = this.getSeconds();
        return ret += (double)this.getNanos() / 1.0E9;
    }

    public void setSeconds(int seconds) {
        int calc = 0;
        if (seconds > 60) {
            this.setMinutes(seconds / 60);
        }
        calc = this.getDays() * 86400 + this.getHours() * 3600 + this.getMinutes() * 60 + seconds % 60;
        this.setValue(this.months, calc, this.nanos);
    }

    public void setSeconds(double seconds) {
        double nanos = seconds - (double)((int)seconds);
        this.setNanos((int)(nanos * 1.0E9));
        int sec = (int)seconds;
        this.setSeconds(sec);
    }

    public int getMilliseconds() {
        return this.getNanos() / 1000000;
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int nanos) {
        this.setValue(this.months, this.seconds, nanos);
    }

    public void setNanos(long nanos) {
        this.setValue(this.months, this.seconds, nanos);
    }

    public boolean isPositive() {
        return this.positive;
    }

    public void setNegative() {
        this.positive = false;
    }

    public void setPositive() {
        this.positive = true;
    }

    @Override
    public int compareTo(Interval o) {
        if (o == null) {
            return 1;
        }
        int val = CommonUtils.compare(this.positive, o.positive);
        if (val != 0) {
            return val;
        }
        val = CommonUtils.compare(this.months, o.months);
        if (val != 0) {
            return val;
        }
        val = CommonUtils.compare(this.seconds, o.seconds);
        if (val != 0) {
            return val;
        }
        val = CommonUtils.compare(this.nanos, o.nanos);
        if (val != 0) {
            return val;
        }
        return 0;
    }

    public Interval toInterval() {
        Interval interval = new Interval();
        interval.setMonths(this.months);
        interval.setSeconds(this.seconds);
        interval.setNanos(this.nanos);
        if (!this.isPositive()) {
            interval.scale(-1);
        }
        return interval;
    }

    protected void cloneProperties(Interval clone) {
        clone.months = this.months;
        clone.nanos = this.nanos;
        clone.seconds = this.seconds;
        clone.positive = this.positive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getYears());
        builder.append("-");
        builder.append(this.getMonths());
        builder.append("-");
        builder.append(this.getDays());
        builder.append(" ");
        builder.append(this.getHours());
        builder.append(":");
        builder.append(this.getMinutes());
        builder.append(":");
        if (this.getNanos() > 0) {
            DecimalFormat decimalFormat = secondsFormat;
            synchronized (decimalFormat) {
                double val = (double)this.getNanos() / 1.0E9 + (double)this.getSeconds();
                builder.append(secondsFormat.format(val));
            }
        } else {
            builder.append(this.getSeconds());
        }
        builder.append("");
        return builder.toString();
    }

    protected int truncate(int val, int sub) {
        return val / sub * sub;
    }

    protected long truncate(long val, long sub) {
        return val / sub * sub;
    }

    static {
        DecimalFormatSymbols dfs = secondsFormat.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        secondsFormat.setDecimalFormatSymbols(dfs);
        UNITS = new String[]{YEAR, MONTH, DAY, HOUR, MINUTE, SECOND};
        YEAR_TO_MONTH = Interval.getTypeName(YEAR, MONTH);
        MONTH_TO_DAY = Interval.getTypeName(MONTH, DAY);
        YEAR_TO_DAY = Interval.getTypeName(YEAR, DAY);
        DAY_TO_SECOND = Interval.getTypeName(DAY, SECOND);
        HOUR_TO_MINUTE = Interval.getTypeName(HOUR, MINUTE);
        HOUR_TO_SECOND = Interval.getTypeName(HOUR, SECOND);
        MINUTE_TO_SECOND = Interval.getTypeName(MINUTE, SECOND);
        INTERVAL_PATTERN = Pattern.compile("\\s*('?[-+]?[0-9]+[ -:0-9]*'?)\\s*(YEAR|MONTH|DAY|HOUR|MINUTE|SECOND){0,1}\\s*(\\([0-9]+\\)){0,1}\\s*(TO){0,1}\\s*(MONTH|DAY|HOUR|MINUTE|SECOND){0,1}.*");
    }
}

