/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractMultiPoint;
import com.sqlapp.data.geometry.Path3D;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.Polygon;
import com.sqlapp.data.geometry.ToLowerDimensionType;
import com.sqlapp.util.CommonUtils;

public class Polygon3D
extends AbstractMultiPoint<Point3D>
implements ToLowerDimensionType<Polygon> {
    private static final long serialVersionUID = 3280634501061893212L;

    public Polygon3D(Point3D ... points) {
        this.setPoints(points);
    }

    public Polygon3D(double ... args) {
        super(args);
    }

    public Polygon3D() {
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof Polygon3D;
    }

    @Override
    public Polygon3D clone() {
        return (Polygon3D)super.clone();
    }

    protected Point3D[] newArray(int size) {
        return new Point3D[size];
    }

    @Override
    protected Point3D newPoint(double ... a) {
        return new Point3D(a[0], a[1], a[2]);
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Polygon toLowerDimension() {
        Point[] points = new Point[((Point3D[])this.points).length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = ((Point3D[])this.points)[i].toLowerDimension();
        }
        return new Polygon(points);
    }

    @Override
    public Polygon3D setValue(String text) {
        text = text.replace("(", "").replace(")", "");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setPoint(vals);
        return this;
    }

    public Path3D toPath() {
        Path3D ret = new Path3D();
        ret.setPoints((Point3D[])this.getPoints());
        return ret;
    }
}

