/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.ToUpperDimensionType;
import com.sqlapp.util.CommonUtils;

public class Point
extends AbstractPoint2D
implements ToUpperDimensionType<Point3D> {
    private static final long serialVersionUID = 3280634501061893212L;

    public Point() {
    }

    public Point(double x, double y) {
        super(x, y);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof Point;
    }

    @Override
    public Point clone() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Point3D toUpperDimension() {
        return new Point3D(this.getX(), this.getY(), 0.0);
    }

    public java.awt.Point toJava2D() {
        java.awt.Point point = new java.awt.Point((int)this.getX(), (int)this.getY());
        return point;
    }

    @Override
    public Point setValue(String text) {
        text = CommonUtils.unwrap(text, "(", ")");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setX(vals[0]);
        this.setY(vals[1]);
        return this;
    }
}

