/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractMultiPoint;
import com.sqlapp.data.geometry.Path3D;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.Polygon;
import com.sqlapp.data.geometry.ToUpperDimensionType;
import com.sqlapp.util.CommonUtils;

public class Path
extends AbstractMultiPoint<Point>
implements ToUpperDimensionType<Path3D> {
    private static final long serialVersionUID = 3280634501061893212L;
    public boolean open = false;

    public Path(boolean open, Point ... points) {
        this.open = open;
        this.setPoints(points);
    }

    public Path(Point ... points) {
        this.setPoints(points);
    }

    public Path(double ... points) {
        this(false, points);
    }

    public Path(boolean open, double ... points) {
        super(points);
        this.open = open;
    }

    public Path() {
    }

    @Override
    protected char getOpen() {
        if (this.open) {
            return '[';
        }
        return '(';
    }

    @Override
    protected char getClose() {
        if (this.open) {
            return ']';
        }
        return ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path cst = (Path)obj;
        return CommonUtils.eq(this.open, cst.open);
    }

    @Override
    public Path clone() {
        return (Path)super.clone();
    }

    protected Point[] newArray(int size) {
        return new Point[size];
    }

    @Override
    protected Point newPoint(double ... a) {
        return new Point(a[0], a[1]);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Path3D toUpperDimension() {
        Point3D[] points = new Point3D[((Point[])this.points).length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = ((Point[])this.points)[i].toUpperDimension();
        }
        return new Path3D(points);
    }

    @Override
    public Path setValue(String text) {
        boolean open = false;
        if (text.contains("[")) {
            text = text.replace("[", "").replace("]", "");
            open = true;
        } else {
            text = text.replace("(", "").replace(")", "");
        }
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.open = open;
        this.setPoint(vals);
        return this;
    }

    public double getArea() {
        double total = 0.0;
        for (int i = 0; i < ((Point[])this.points).length - 1; ++i) {
            total += (((Point[])this.points)[i + 1].getX() - ((Point[])this.points)[i].getX()) * (((Point[])this.points)[i + 1].getY() - ((Point[])this.points)[i].getY() / 2.0);
        }
        return Math.abs(total += (((Point[])this.points)[0].getX() - ((Point[])this.points)[((Point[])this.points).length - 1].getX()) * (((Point[])this.points)[0].getY() - ((Point[])this.points)[((Point[])this.points).length - 1].getY() / 2.0));
    }

    public Polygon toPolygon() {
        Polygon ret = new Polygon();
        ret.setPoints((Point[])this.getPoints());
        return ret;
    }
}

