/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.data.geometry.Circle;
import com.sqlapp.data.geometry.ToLowerDimensionType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;

public class Circle3D
extends AbstractPoint2D
implements ToLowerDimensionType<Circle> {
    private static final long serialVersionUID = 3280634501061893212L;
    public double z = 0.0;
    private double r = 0.0;

    public Circle3D(double x, double y, double z, double r) {
        super(x, y);
        this.z = z;
        this.r = r;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<(").append(this.getX()).append(",").append(this.getY()).append(",").append(this.getZ()).append("),").append(this.getR()).append(">");
        return builder.toString();
    }

    @Override
    protected void hashCode(HashCodeBuilder builder) {
        builder.append(this.r);
        builder.append(this.z);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Circle3D)) {
            return false;
        }
        Circle3D cst = (Circle3D)obj;
        if (!CommonUtils.eq(this.getZ(), cst.getZ())) {
            return false;
        }
        return CommonUtils.eq(this.getR(), cst.getR());
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    @Override
    public Circle3D clone() {
        return new Circle3D(this.getX(), this.getY(), this.getZ(), this.r);
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Circle toLowerDimension() {
        return new Circle(this.getX(), this.getY(), this.getR());
    }

    @Override
    public Circle3D setValue(String text) {
        text = CommonUtils.unwrap(text, "<", ">");
        text = text.replace("(", "").replace(")", "");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        Double[] vals = Converters.getDefault().convertObject(values, Double[].class);
        this.setX(vals[0]);
        this.setY(vals[1]);
        this.setZ(vals[2]);
        this.setR(vals[3]);
        return this;
    }
}

