/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SqlMetaType;
import com.sqlapp.data.schemas.State;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.EnumUtils;
import java.util.Comparator;

public enum SqlType {
    IDENTITY_ON(SqlMetaType.DCL){

        @Override
        public SqlType reverse() {
            return IDENTITY_OFF;
        }
    }
    ,
    IDENTITY_OFF(SqlMetaType.DCL){

        @Override
        public SqlType reverse() {
            return IDENTITY_ON;
        }
    }
    ,
    DDL_AUTOCOMMIT_ON(SqlMetaType.DCL){

        @Override
        public SqlType reverse() {
            return DDL_AUTOCOMMIT_OFF;
        }
    }
    ,
    DDL_AUTOCOMMIT_OFF(SqlMetaType.DCL){

        @Override
        public SqlType reverse() {
            return DDL_AUTOCOMMIT_ON;
        }
    }
    ,
    SET_SEARCH_PATH_TO_SCHEMA(SqlMetaType.DCL),
    GRANT(SqlMetaType.DCL){

        @Override
        public SqlType reverse() {
            return REVOKE;
        }
    }
    ,
    REVOKE(SqlMetaType.DCL){

        @Override
        public SqlType reverse() {
            return GRANT;
        }
    }
    ,
    ANALYZE(SqlMetaType.DCL),
    DEFRAG(SqlMetaType.DCL),
    DEFRAG_FULL(SqlMetaType.DCL),
    OPTIMIZE(SqlMetaType.DCL),
    REPAIR(SqlMetaType.DCL),
    REBUILD(SqlMetaType.DCL),
    SELECT(SqlMetaType.DML),
    SELECT_ALL(SqlMetaType.DML),
    SELECT_BY_PK(SqlMetaType.DML),
    INSERT(SqlMetaType.DML, State.Added){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }

        @Override
        public SqlType reverse() {
            return DELETE;
        }
    }
    ,
    INSERT_ROW(SqlMetaType.DML, State.Added){

        @Override
        public boolean supportRows() {
            return true;
        }

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }

        @Override
        public SqlType reverse() {
            return DELETE_ROW;
        }
    }
    ,
    INSERT_SELECT_ROW(SqlMetaType.DML, State.Added){

        @Override
        public boolean supportRows() {
            return true;
        }

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    INSERT_SELECT_BY_PK(SqlMetaType.DML, State.Added){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    INSERT_SELECT_ALL(SqlMetaType.DML, State.Added){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    UPDATE(SqlMetaType.DML, State.Modified){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    UPDATE_BY_PK(SqlMetaType.DML, State.Modified){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }

        @Override
        public final boolean isOptimisticLockable() {
            return true;
        }
    }
    ,
    UPDATE_ROW(SqlMetaType.DML, State.Modified){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }

        @Override
        public boolean supportRows() {
            return true;
        }
    }
    ,
    UPDATE_ALL(SqlMetaType.DML, State.Modified){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    DELETE_BY_PK(SqlMetaType.DML, State.Deleted){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.DROP.getComparator();
        }

        @Override
        public final boolean isOptimisticLockable() {
            return true;
        }
    }
    ,
    DELETE(SqlMetaType.DML, State.Deleted){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.DROP.getComparator();
        }

        @Override
        public SqlType reverse() {
            return INSERT;
        }
    }
    ,
    DELETE_ROW(SqlMetaType.DML, State.Deleted){

        @Override
        public boolean supportRows() {
            return true;
        }

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.DROP.getComparator();
        }

        @Override
        public SqlType reverse() {
            return INSERT_ROW;
        }
    }
    ,
    DELETE_ALL(SqlMetaType.DML, State.Deleted){

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.DROP.getComparator();
        }
    }
    ,
    MERGE_BY_PK(SqlMetaType.DML, State.Modified){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{INSERT_SELECT_BY_PK, UPDATE_BY_PK};
        }

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    MERGE_ROW(SqlMetaType.DML, State.Modified){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{INSERT_SELECT_ROW, UPDATE};
        }

        @Override
        public boolean supportRows() {
            return true;
        }

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    MERGE_ALL(SqlMetaType.DML, State.Modified){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{INSERT_SELECT_ALL, UPDATE_ALL};
        }

        @Override
        public Comparator<Table> getTableComparator() {
            return Table.TableOrder.CREATE.getComparator();
        }
    }
    ,
    LOCK(SqlMetaType.DML),
    CREATE(SqlMetaType.DDL, State.Added){

        @Override
        public SqlType reverse() {
            return DROP;
        }
    }
    ,
    DROP(SqlMetaType.DDL, State.Deleted){

        @Override
        public SqlType reverse() {
            return CREATE;
        }
    }
    ,
    ALTER(SqlMetaType.DDL, State.Modified){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{DROP, CREATE};
        }
    }
    ,
    ADD_PARTITION(SqlMetaType.DDL, State.Added){

        @Override
        public SqlType reverse() {
            return DROP_PARTITION;
        }
    }
    ,
    DROP_PARTITION(SqlMetaType.DDL, State.Deleted){

        @Override
        public SqlType reverse() {
            return ADD_PARTITION;
        }
    }
    ,
    MODIFY_PARTITION(SqlMetaType.DDL, State.Deleted){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{DROP_PARTITION, ADD_PARTITION};
        }
    }
    ,
    MERGE_PARTITION(SqlMetaType.DDL, State.Modified){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{DROP_PARTITION, ADD_PARTITION};
        }

        @Override
        public SqlType reverse() {
            return SPLIT_PARTITION;
        }
    }
    ,
    SPLIT_PARTITION(SqlMetaType.DDL, State.Modified){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{ADD_PARTITION};
        }

        @Override
        public SqlType reverse() {
            return MERGE_PARTITION;
        }
    }
    ,
    TRUNCATE(SqlMetaType.DDL, State.Deleted){

        @Override
        public SqlType[] getSurrogates() {
            return new SqlType[]{DELETE_ALL, COMMIT};
        }
    }
    ,
    REFRESH(SqlMetaType.DDL, null),
    REFRESH_FAST(SqlMetaType.DDL, null),
    REFRESH_COMPLETE(SqlMetaType.DDL, null),
    SET_COMMENT(SqlMetaType.COMMENT, null),
    COMMIT(SqlMetaType.TCL),
    ROLLBACK(SqlMetaType.TCL),
    COMMENT(SqlMetaType.COMMENT, null){

        @Override
        public boolean isComment() {
            return true;
        }
    }
    ,
    EMPTY_LINE(SqlMetaType.EMPTY_LINE, null){

        @Override
        public boolean isEmptyLine() {
            return true;
        }
    }
    ,
    OTHER(SqlMetaType.OTHER, null);

    private final State state;
    private final SqlMetaType sqlMetaType;
    private static final SqlType[] EMPTY;

    private SqlType(SqlMetaType sqlMetaType, State state) {
        this.sqlMetaType = sqlMetaType;
        this.state = state;
    }

    private SqlType(SqlMetaType sqlMetaType) {
        this(sqlMetaType, null);
    }

    public SqlMetaType getSqlMetaType() {
        return this.sqlMetaType;
    }

    public Comparator<Table> getTableComparator() {
        return null;
    }

    public boolean isDml() {
        return this.sqlMetaType == SqlMetaType.DML;
    }

    public boolean isDcl() {
        return this.sqlMetaType == SqlMetaType.DCL;
    }

    public boolean isComment() {
        return false;
    }

    public boolean isEmptyLine() {
        return false;
    }

    public SqlType reverse() {
        return this;
    }

    public boolean isDdl() {
        return this.sqlMetaType == SqlMetaType.DDL;
    }

    public SqlType[] getSurrogates() {
        return EMPTY;
    }

    public State getState() {
        return this.state;
    }

    public boolean supportRows() {
        return false;
    }

    public boolean isOptimisticLockable() {
        return false;
    }

    public static SqlType parse(String type) {
        return EnumUtils.parse(SqlType.class, type);
    }

    static {
        EMPTY = new SqlType[0];
    }
}

