/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractUpdateTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createSql(Table table) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Object builder = this.createSqlBuilder();
        this.addUpdateTable(table, builder);
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, this.getSqlType(), table);
        return sqlList;
    }

    protected abstract SqlType getSqlType();

    protected void addUpdateTable(Table obj, S builder) {
        ((AbstractSqlBuilder)builder).update();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak()).set();
        List<Column> uniqueColumns = obj.getUniqueColumns();
        ColumnCollection columns = obj.getColumns();
        boolean[] first = new boolean[]{true};
        for (Column column : columns) {
            if (uniqueColumns != null && uniqueColumns.contains(column) || !this.isUpdateable(column)) continue;
            String def = this.getValueDefinitionForUpdate(column);
            ((AbstractSqlBuilder)builder).$if(def != null, () -> {
                builder.lineBreak();
                builder.comma(!first[0]);
                ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.name(column)).space()).eq();
                ((AbstractSqlBuilder)builder.space())._add(def);
                String comment = (String)this.getOptions().getTableOptions().getUpdateColumnComment().apply((String)((Object)column));
                if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                    ((AbstractSqlBuilder)builder.space()).addComment(comment);
                }
                first[0] = false;
            });
        }
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).where())._true();
        this.addUpdateConditionColumns(obj, builder);
    }

    protected abstract void addUpdateConditionColumns(Table var1, S var2);
}

