/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractRowFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractUpdateRowFactory<S extends AbstractSqlBuilder<?>>
extends AbstractRowFactory<S> {
    @Override
    protected List<SqlOperation> getOperations(Row row) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Table table = row.getTable();
        Object builder = this.createSqlBuilder();
        this.addUpdateTable(table, row, builder);
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.UPDATE_ROW, row);
        return sqlList;
    }

    protected void addUpdateTable(Table obj, Row row, S builder) {
        ((AbstractSqlBuilder)builder).update();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak()).set();
        List<Column> uniqueColumns = obj.getUniqueColumns();
        ColumnCollection columns = obj.getColumns();
        boolean[] first = new boolean[]{true};
        for (Column column : columns) {
            if (uniqueColumns != null && uniqueColumns.contains(column) || !this.isUpdateable(column)) continue;
            String def = this.getValueDefinitionForUpdate(row, column);
            ((AbstractSqlBuilder)builder).$if(!CommonUtils.isEmpty(def), () -> {
                builder.lineBreak();
                builder.comma(!first[0]);
                ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.name(column)).space()).eq();
                ((AbstractSqlBuilder)builder.space())._add(def);
                String comment = (String)this.getOptions().getTableOptions().getUpdateColumnComment().apply((String)((Object)column));
                if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                    ((AbstractSqlBuilder)builder.space()).addComment(comment);
                }
                first[0] = false;
            });
        }
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).where())._true();
        this.addUniqueColumnsCondition(obj, row, (AbstractSqlBuilder<?>)builder);
    }
}

