/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractSelectTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createSql(Table obj) {
        Object builder = this.createSqlBuilder();
        this.addSelectFromTable(obj, builder);
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).where())._true();
        super.addConditionColumns(obj, builder);
        this.addOrderBy(obj, builder);
        this.addOffsetRowsOnly(obj, builder);
        List<SqlOperation> sqlList = CommonUtils.list();
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.SELECT, obj);
        return sqlList;
    }

    protected void addSelectFromTable(Table obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).select()).space())._add(this.toIfExpression("!_countSql"));
        this.addSelectAllColumns(obj, builder);
        ((AbstractSqlBuilder)builder)._add("--else count(*)");
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)builder)._add(this.getEndIfExpression());
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).from()).space()).name(obj, this.getOptions().isDecorateSchemaName());
    }

    protected void addOrderBy(Table obj, S builder) {
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)builder)._add(this.toIfExpression("!_countSql && " + this.toIsNotEmptyExpression("_orderBy")));
        ((AbstractSqlBuilder)builder).lineBreak();
        List<Column> columns = obj.getUniqueColumns();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).orderBy()).space();
        ((AbstractSqlBuilder)builder).setAppendAutoSpace(false);
        ((AbstractSqlBuilder)builder).addComment("$_orderBy;sqlKeywordCheck=true");
        if (!CommonUtils.isEmpty(columns)) {
            ((AbstractSqlBuilder)builder).names(columns.toArray(new Column[0]));
        } else {
            ((AbstractSqlBuilder)builder).names((Column)obj.getColumns().get(0));
        }
        ((AbstractSqlBuilder)builder).setAppendAutoSpace(true);
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)builder)._add(this.getEndIfExpression());
    }

    protected void addOffsetRowsOnly(Table obj, S builder) {
        if (this.getDialect().supportsStandardOffsetFetchRows()) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression("_offset"))).lineBreak();
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).offset()).space())._add("/*_offset*/1")).space()).rows();
            ((AbstractSqlBuilder)builder).lineBreak();
            ((AbstractSqlBuilder)builder)._add(this.getEndIfExpression());
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression("_row"))).lineBreak();
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).fetch()).first()).space())._add("/*_row*/1")).space()).rows()).only();
            ((AbstractSqlBuilder)builder).lineBreak();
            ((AbstractSqlBuilder)builder)._add(this.getEndIfExpression());
        }
    }
}

