/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SimpleSqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.List;

public abstract class AbstractRowFactory<S extends AbstractSqlBuilder<?>>
extends SimpleSqlFactory<DbCommonObject<?>, S> {
    @Override
    public List<SqlOperation> createSql(Collection<DbCommonObject<?>> c) {
        return this.getOperationsInternal(c);
    }

    @Override
    public List<SqlOperation> createSql(DbCommonObject<?> obj) {
        if (obj instanceof Table) {
            return this.createSql(((Table)obj).getRows());
        }
        if (obj instanceof RowCollection) {
            return this.getOperationsInternal((RowCollection)obj);
        }
        if (obj instanceof Collection) {
            return this.getOperationsInternal((Collection)((Object)obj));
        }
        if (obj instanceof Row) {
            List<Row> batchRows = CommonUtils.list(1);
            Row row = (Row)Row.class.cast(obj);
            batchRows.add(row);
            return this.getOperations(row.getTable(), batchRows);
        }
        throw new IllegalArgumentException("arg=" + obj);
    }

    protected List<SqlOperation> getOperationsInternal(Collection<Row> rows) {
        List<SqlOperation> result = CommonUtils.list();
        if (CommonUtils.isEmpty(rows)) {
            return result;
        }
        List<Row> batchRows = CommonUtils.list();
        Table table = null;
        int batchSize = 1;
        for (Row row : rows) {
            if (table == null) {
                table = row.getTable();
                batchSize = (Integer)this.getOptions().getTableOptions().getDmlBatchSize().apply(table);
            }
            batchRows.add(row);
            if (batchRows.size() != batchSize) continue;
            List<SqlOperation> ops = this.getOperations(table, batchRows);
            result.addAll(ops);
            batchRows.clear();
        }
        if (batchRows.size() > 0) {
            List<SqlOperation> ops = this.getOperations(table, batchRows);
            result.addAll(ops);
            batchRows.clear();
        }
        return result;
    }

    protected List<SqlOperation> getOperations(Table table, Collection<Row> rows) {
        List<SqlOperation> result = CommonUtils.list();
        for (Row row : rows) {
            List<SqlOperation> ops = this.getOperations(row);
            result.addAll(ops);
        }
        return result;
    }

    protected abstract List<SqlOperation> getOperations(Row var1);

    protected Table toTable(DbCommonObject<?> obj) {
        if (obj instanceof Table) {
            return (Table)obj;
        }
        if (obj instanceof RowCollection) {
            return ((RowCollection)obj).getParent();
        }
        if (obj instanceof Row) {
            return ((Row)obj).getTable();
        }
        return null;
    }

    protected void addInsertIntoTable(Table table, Row row, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).insert()).into()).table();
        ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space())._add("(");
        ColumnCollection columns = table.getColumns();
        boolean[] first = new boolean[]{false};
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            String def = this.getValueDefinitionForInsert(row, column);
            ((AbstractSqlBuilder)builder).$if(def != null, () -> {
                if (!this.isFormulaColumn(column)) {
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.comma(!first[0])).space(2, !first[0]);
                    builder.name(column);
                    first[0] = false;
                }
            });
        }
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)builder)._add(")");
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)builder).values();
    }

    protected void addUniqueColumnsCondition(Table table, Row row, AbstractSqlBuilder<?> builder) {
        builder.setQuateObjectName(this.getOptions().isQuateColumnName());
        List<Column> columns = table.getUniqueColumns();
        if (columns == null) {
            columns = CommonUtils.list();
            columns.addAll(table.getColumns());
        }
        builder.appendIndent(1);
        boolean[] first = new boolean[]{true};
        for (Column column : columns) {
            String def = this.getValueDefinitionForCondition(row, column);
            builder.$if(def != null, () -> {
                builder.lineBreak();
                ((AbstractSqlBuilder)builder.and(!first[0])).name(column);
                if ("IS NULL".equals(def)) {
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.space()).is())._null();
                } else {
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.space()).eq()).space())._add(def);
                }
                first[0] = false;
            });
        }
        builder.appendIndent(-1);
        builder.setQuateObjectName(false);
    }

    protected UniqueConstraint getUniqueConstraint(Table table) {
        UniqueConstraint constraint = table.getConstraints().getPrimaryKeyConstraint();
        if (constraint == null) {
            constraint = CommonUtils.first(table.getConstraints().getUniqueConstraints());
        }
        return constraint;
    }
}

