/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractMergeAllTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createSql(Table table) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Object builder = this.createSqlBuilder();
        this.addMergeTable(table, builder);
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.MERGE_ALL, table);
        return sqlList;
    }

    protected void addMergeTable(Table obj, S builder) {
        Table source;
        String sourceTableName = (String)this.getOptions().getTableOptions().getTempTableName().apply(obj);
        Table table = source = obj.getParent() != null ? (Table)obj.getParent().get(sourceTableName) : null;
        if (source == null) {
            source = (Table)obj.clone();
            source.setName(sourceTableName);
        }
        String targetTableAlias = "_target_";
        String sourceTableAlias = "_source_";
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).merge()).space();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).as()).space())._add("_target_");
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).using()).name(source, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).as()).space())._add("_source_");
        ((AbstractSqlBuilder)builder).lineBreak();
        UniqueConstraint uk = obj.getPrimaryKeyConstraint();
        Set<String> pkCols = CommonUtils.linkedSet();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).on()).brackets(() -> {
            builder.indent(() -> {
                int i = 0;
                for (ReferenceColumn rc : uk.getColumns()) {
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.and(i > 0)).name("_target_.", rc);
                    builder.eq();
                    builder.name("_source_.", rc);
                    pkCols.add(rc.getName());
                    ++i;
                }
            });
            builder.lineBreak();
        });
        this.addMergeTableWhenMatched(obj, "_target_", "_source_", pkCols, builder);
        this.addMergeTableWhenNotMatched(obj, "_target_", "_source_", pkCols, builder);
        this.addMergeTableWhenNotMatchedBySource(obj, "_target_", "_source_", pkCols, builder);
        this.addMergeTableAfter(obj, builder);
    }

    protected void addMergeTableAfter(Table obj, S builder) {
    }

    protected void addMergeTableWhenMatched(Table obj, String targetTableAlias, String sourceTableAlias, Set<String> pkCols, S builder) {
        ((AbstractSqlBuilder)builder).lineBreak();
        this.addWhenMatched(obj, targetTableAlias, sourceTableAlias, builder);
        ((AbstractSqlBuilder)builder).indent(() -> {
            builder.lineBreak();
            ((AbstractSqlBuilder)builder.then()).update();
            builder.indent(() -> {
                int i = 0;
                for (Column column : obj.getColumns()) {
                    if (!this.isUpdateable(column) || pkCols.contains(column.getName())) continue;
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.lineBreak()).set(i == 0)).comma(i > 0);
                    ((AbstractSqlBuilder)builder.name(targetTableAlias + ".", column)).eq();
                    String value = (String)this.getOptions().getTableOptions().getUpdateTableColumnValue().apply((String)((Object)column));
                    if (value != null && !Objects.equals(value, column.getName())) {
                        builder._add(value);
                    } else {
                        builder.name(sourceTableAlias + ".", column);
                    }
                    String comment = (String)this.getOptions().getTableOptions().getUpdateColumnComment().apply((String)((Object)column));
                    if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                        ((AbstractSqlBuilder)builder.space()).addComment(comment);
                    }
                    ++i;
                }
                this.addMergeTableWhenMatchedWhere(obj, targetTableAlias, sourceTableAlias, pkCols, builder);
            });
        });
        ((AbstractSqlBuilder)builder).lineBreak();
    }

    protected void addWhenMatched(Table obj, String targetTableAlias, String sourceTableAlias, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).when()).matched();
    }

    protected void addMergeTableWhenMatchedWhere(Table obj, String targetTableAlias, String sourceTableAlias, Set<String> pkCols, S builder) {
    }

    protected void addMergeTableWhenNotMatched(Table obj, String targetTableAlias, String sourceTableAlias, Set<String> pkCols, S builder) {
        this.addWhenNotMatched(obj, targetTableAlias, sourceTableAlias, builder);
        List insertColumns = CommonUtils.list();
        ((AbstractSqlBuilder)builder).indent(() -> {
            builder.lineBreak();
            ((AbstractSqlBuilder)builder.then()).insert();
            builder.lineBreak();
            builder.brackets(() -> {
                builder.indent(() -> {
                    int i = 0;
                    for (Column column : obj.getColumns()) {
                        if (!this.isInsertable(column)) continue;
                        String comment = (String)this.getOptions().getTableOptions().getInsertColumnComment().apply((String)((Object)column));
                        if (column.isIdentity()) {
                            if (CommonUtils.isEmpty(this.getDialect().getIdentityInsertString())) continue;
                            insertColumns.add(column);
                            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.lineBreak()).comma(i > 0)).name(column);
                            if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                                ((AbstractSqlBuilder)builder.space()).addComment(comment);
                            }
                            ++i;
                            continue;
                        }
                        if (this.isFormulaColumn(column)) continue;
                        insertColumns.add(column);
                        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.lineBreak()).comma(i > 0)).name(column);
                        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                            ((AbstractSqlBuilder)builder.space()).addComment(comment);
                        }
                        ++i;
                    }
                });
                builder.lineBreak();
            });
            builder.lineBreak();
            builder.values();
            builder.lineBreak();
            builder.brackets(() -> {
                builder.indent(() -> {
                    int i = 0;
                    for (Column column : insertColumns) {
                        ((AbstractSqlBuilder)builder.lineBreak()).comma(i > 0);
                        String value = (String)this.getOptions().getTableOptions().getInsertTableColumnValue().apply((String)((Object)column));
                        if (column.getDefaultValue() != null) {
                            builder.coalesce(() -> {
                                if (value != null && !Objects.equals(value, column.getName())) {
                                    builder._add(value);
                                } else {
                                    builder.name(sourceTableAlias + ".", column);
                                }
                                ((AbstractSqlBuilder)builder.comma())._add(column.getDefaultValue());
                            });
                        } else if (value != null && !Objects.equals(value, column.getName())) {
                            builder._add(value);
                        } else {
                            builder.name(sourceTableAlias + ".", column);
                        }
                        ++i;
                    }
                });
                builder.lineBreak();
            });
            this.addMergeTableWhenNotMatchedWhere(obj, targetTableAlias, sourceTableAlias, pkCols, builder);
        });
    }

    protected void addWhenNotMatched(Table obj, String targetTableAlias, String sourceTableAlias, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).when()).not()).matched();
    }

    protected void addMergeTableWhenNotMatchedWhere(Table obj, String targetTableAlias, String sourceTableAlias, Set<String> pkCols, S builder) {
    }

    protected void addMergeTableWhenNotMatchedBySource(Table obj, String targetTableAlias, String sourceTableAlias, Set<String> pkCols, S builder) {
    }
}

