/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractInsertTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createSql(Table table) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Object builder = this.createSqlBuilder();
        List<Column> list = this.addInsertIntoTable(table, builder);
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)builder).brackets(() -> {
            builder.indent(() -> {
                int i = 0;
                for (Column column : list) {
                    String def = this.getValueDefinitionForInsert(column);
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.comma(i > 0)).space(2, i == 0);
                    builder._add(def);
                    ++i;
                }
            });
            builder.lineBreak();
        });
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.INSERT, table);
        return sqlList;
    }

    protected List<Column> addInsertIntoTable(Table obj, S builder) {
        List<Column> list = CommonUtils.list();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).insert()).into()).space();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).lineBreak();
        ((AbstractSqlBuilder)builder).brackets(() -> {
            builder.indent(() -> {
                int i = 0;
                for (Column column : obj.getColumns()) {
                    if (!this.isInsertable(column) || this.isFormulaColumn(column)) continue;
                    if (this.isAutoIncrementColumn(column)) {
                        Dialect dialect = builder.getDialect();
                        if (CommonUtils.isEmpty(dialect.getIdentityInsertString())) continue;
                        builder.lineBreak();
                        ((AbstractSqlBuilder)builder.comma(i > 0)).space(2, i == 0);
                        builder.name(column);
                        String comment = (String)this.getOptions().getTableOptions().getInsertColumnComment().apply((String)((Object)column));
                        if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                            ((AbstractSqlBuilder)builder.space()).addComment(comment);
                        }
                        list.add(column);
                        ++i;
                        continue;
                    }
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.comma(i > 0)).space(2, i == 0);
                    builder.name(column);
                    String comment = (String)this.getOptions().getTableOptions().getInsertColumnComment().apply((String)((Object)column));
                    if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                        ((AbstractSqlBuilder)builder.space()).addComment(comment);
                    }
                    list.add(column);
                    ++i;
                }
            });
            builder.lineBreak();
        });
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak()).values();
        return list;
    }
}

