/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractSchemaObjectReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.ArgumentRoutine;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public abstract class RoutineReader<T extends ArgumentRoutine<? super T>>
extends AbstractSchemaObjectReader<T> {
    protected RoutineReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected void setMetadataDetail(Connection connection, ParametersContext context, List<T> list) throws SQLException {
        TripleKeyMap<Object, Object, Object, Object> argumentMap = !list.isEmpty() ? this.getObjectKeyMap(connection, this.setReaderParameter(this.getRoutineArgumentReader(), list)) : new TripleKeyMap();
        for (ArgumentRoutine obj : list) {
            String name;
            obj.setDialect(this.getDialect());
            String string = name = obj.getSpecificName() != null ? obj.getSpecificName() : obj.getName();
            List args = (List)argumentMap.get(obj.getCatalogName(), obj.getSchemaName(), name);
            if (CommonUtils.isEmpty(args)) continue;
            obj.getArguments().addAll(args);
            argumentMap.remove(obj.getCatalogName(), obj.getSchemaName(), name);
        }
    }

    protected TripleKeyMap<String, String, String, List<NamedArgument>> getObjectKeyMap(Connection connection, RoutineArgumentReader<?> reader) {
        if (reader == null) {
            return new TripleKeyMap<String, String, String, List<NamedArgument>>();
        }
        List ccList = reader.getAllFull(connection);
        TripleKeyMap<String, String, String, List<NamedArgument>> ccMap = CommonUtils.tripleKeyMap();
        for (NamedArgument argument : ccList) {
            List<NamedArgument> args;
            String name = ((AbstractNamedObject)argument.getRoutine()).getName();
            if (((Routine)argument.getRoutine()).getSpecificName() != null) {
                name = ((Routine)argument.getRoutine()).getSpecificName();
            }
            if ((args = ccMap.get(argument.getCatalogName(), argument.getSchemaName(), name)) == null) {
                args = CommonUtils.list();
                ccMap.put(argument.getCatalogName(), argument.getSchemaName(), name, args);
            }
            args.add(argument);
        }
        return ccMap;
    }

    protected void setReaderParameter(RoutineArgumentReader<?> reader) {
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            SimpleBeanUtils.setValue(reader, "schemaName", this.getSchemaName());
            reader.setObjectName(this.getObjectName());
            this.initializeChild(reader);
        }
    }

    protected RoutineArgumentReader<?> setReaderParameter(RoutineArgumentReader<?> reader, List<T> list) {
        if (reader == null) {
            return reader;
        }
        Set schemaNames = CommonUtils.set();
        for (ArgumentRoutine obj : list) {
            if (obj.getSchemaName() == null) continue;
            schemaNames.add(obj.getSchemaName());
        }
        if (schemaNames.size() == 1) {
            reader.setSchemaName((String)CommonUtils.first(schemaNames));
        }
        return reader;
    }

    protected RoutineArgumentReader<?> getRoutineArgumentReader() {
        RoutineArgumentReader<?> reader = this.newRoutineArgumentReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract RoutineArgumentReader<?> newRoutineArgumentReader();
}

