/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractNamedMetadataReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.MviewLog;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.util.List;

public abstract class MviewLogColumnReader
extends AbstractNamedMetadataReader<ReferenceColumn, MviewLog> {
    private String schemaName = null;
    private String columnName = null;

    protected MviewLogColumnReader(Dialect dialect) {
        super(dialect);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    protected String getTableName(ParametersContext context) {
        return (String)context.get(this.getNameLabel());
    }

    protected void setTableName(ParametersContext context, String tableName) {
        context.put(this.getNameLabel(), (Object)tableName);
    }

    @Override
    public void loadFull(Connection connection, MviewLog table) {
        List list = this.getAllFull(connection);
        int size = list.size();
        ReferenceColumnCollection c = this.getSchemaObjectList(table);
        for (int i = 0; i < size; ++i) {
            ReferenceColumn obj = (ReferenceColumn)list.get(i);
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, MviewLog table) {
        List list = this.getAll(connection);
        int size = list.size();
        ReferenceColumnCollection c = this.getSchemaObjectList(table);
        for (int i = 0; i < size; ++i) {
            ReferenceColumn obj = (ReferenceColumn)list.get(i);
            c.add(obj);
        }
    }

    protected TripleKeyMap<String, String, String, List<ReferenceColumn>> toKeyMap(List<ReferenceColumn> list) {
        TripleKeyMap<String, String, String, List<ReferenceColumn>> map = new TripleKeyMap<String, String, String, List<ReferenceColumn>>();
        for (ReferenceColumn obj : list) {
            List<ReferenceColumn> tableConsts = map.get(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName());
            if (tableConsts == null) {
                tableConsts = CommonUtils.list();
                map.put(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName(), tableConsts);
            }
            tableConsts.add(obj);
        }
        return map;
    }

    protected ReferenceColumnCollection getSchemaObjectList(MviewLog mviewLog) {
        return mviewLog.getColumns();
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName(), this.getSchemaName());
        this.setTableName(context, this.nativeCaseString(connection, this.getObjectName()));
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getColumnName()));
        return context;
    }

    @Override
    protected String getNameLabel() {
        return SchemaProperties.COLUMN_NAME.getLabel();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    protected String getColumnName(ParametersContext context) {
        return (String)context.get(SchemaProperties.COLUMN_NAME.getLabel());
    }
}

