/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MviewReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Mview;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.View;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataReaderUtils {
    private static final Map<Class<?>, Set<Class<?>>> SUPPORTED_TYPE_CACHE = CommonUtils.map();
    private static final Pattern READER_PATTERN = Pattern.compile("get.*Reader", 2);

    private MetadataReaderUtils() {
    }

    public static <T extends MetadataReader<?, ?>> T getMetadataReader(Dialect dialect, String name) {
        CatalogReader catalogReader = dialect.getCatalogReader();
        Object reader = catalogReader.getMetadataReader(name);
        if (reader != null) {
            return reader;
        }
        SchemaReader schemaReader = catalogReader.getSchemaReader();
        reader = schemaReader.getMetadataReader(name);
        if (reader != null) {
            return reader;
        }
        TableReader tableReader = schemaReader.getTableReader();
        reader = tableReader.getMetadataReader(name);
        if (reader != null) {
            return reader;
        }
        return null;
    }

    protected static <T extends MetadataReader<?, ?>> T getMetadataReader(MetadataReader<?, ?> reader, String name) {
        MetadataReader obj = (MetadataReader)SimpleBeanUtils.getInstance(reader.getClass()).getValueCI(reader, SchemaUtils.getSingularName(name) + "Reader");
        return (T)obj;
    }

    public static Set<Class<?>> supportedSchemaTypes(CatalogReader reader) {
        Set<Class<Object>> types = SUPPORTED_TYPE_CACHE.get(reader.getClass());
        if (types == null) {
            types = CommonUtils.set();
            types.add(Catalog.class);
            types.add(Schema.class);
            List<MetadataReader<?, ?>> metadataReaders = MetadataReaderUtils.getRecursiveMetadataReaders(reader);
            for (MetadataReader<?, ?> metadataReader : metadataReaders) {
                types.add(MetadataReaderUtils.getMetaClass(metadataReader));
            }
            types = Collections.unmodifiableSet(types);
            SUPPORTED_TYPE_CACHE.put(reader.getClass(), types);
        }
        return types;
    }

    private static List<MetadataReader<?, ?>> getRecursiveMetadataReaders(MetadataReader<?, ?> reader) {
        List<MetadataReader<?, ?>> result = CommonUtils.list();
        result.add(reader);
        List<MetadataReader<?, ?>> metadataReaders = MetadataReaderUtils.getChildMetadataReaders(reader);
        for (MetadataReader<?, ?> metadataReader : metadataReaders) {
            List<MetadataReader<?, ?>> childMetadataReaders = MetadataReaderUtils.getRecursiveMetadataReaders(metadataReader);
            result.addAll(childMetadataReaders);
        }
        return result;
    }

    private static List<MetadataReader<?, ?>> getChildMetadataReaders(MetadataReader<?, ?> reader) {
        Method[] methods;
        List<MetadataReader<?, ?>> readers = CommonUtils.list();
        if (reader == null) {
            return readers;
        }
        for (Method method : methods = reader.getClass().getMethods()) {
            String name = method.getName();
            Matcher matcher = READER_PATTERN.matcher(name);
            if (!matcher.matches() || name.contains("Parent") || !CommonUtils.isEmpty(method.getParameterTypes())) continue;
            try {
                MetadataReader obj = (MetadataReader)method.invoke(reader, new Object[0]);
                if (obj == null) continue;
                readers.add(obj);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return readers;
    }

    public static Class<?> getMetaClass(MetadataReader<?, ?> reader) {
        if (reader instanceof ViewReader) {
            return View.class;
        }
        if (reader instanceof MviewReader) {
            return Mview.class;
        }
        Class<?> clazz = reader.getClass();
        Class<?> ret = MetadataReaderUtils.getTypeParameterClass(clazz);
        if (ret != null) {
            return ret;
        }
        return MetadataReaderUtils.getTypeGenericSuperclass(clazz);
    }

    public static Class<?> getMetaClass(Class<? extends MetadataReader<?, ?>> clazz) {
        if (ViewReader.class.isAssignableFrom(clazz)) {
            return View.class;
        }
        if (MviewReader.class.isAssignableFrom(clazz)) {
            return Mview.class;
        }
        Class<?> ret = MetadataReaderUtils.getTypeParameterClass(clazz);
        if (ret != null) {
            return ret;
        }
        return MetadataReaderUtils.getTypeGenericSuperclass(clazz);
    }

    protected static Class<?> getTypeGenericSuperclass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Type type = clazz.getGenericSuperclass();
        if (CommonUtils.isEmpty(type)) {
            return MetadataReaderUtils.getTypeGenericSuperclass(clazz.getSuperclass());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type retType = pt.getActualTypeArguments()[0];
            return (Class)retType;
        }
        if (MetadataReader.class.isAssignableFrom((Class)type)) {
            Class<?> ret = MetadataReaderUtils.getTypeParameterClass((Class)type);
            if (ret != null) {
                return ret;
            }
            return MetadataReaderUtils.getTypeGenericSuperclass(clazz.getSuperclass());
        }
        return null;
    }

    public static Class<?> getTypeParameterClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        TypeVariable<Class<?>>[] typvs = clazz.getTypeParameters();
        if (CommonUtils.isEmpty(typvs)) {
            Class<?> ret = MetadataReaderUtils.getTypeParameterClass(clazz.getSuperclass());
            if (ret != null) {
                return ret;
            }
        } else {
            for (TypeVariable<Class<?>> typv : typvs) {
                Type[] types;
                for (Type type : types = typv.getBounds()) {
                    Class<?> ret;
                    ParameterizedType ptype;
                    Type rawType;
                    if (!(type instanceof ParameterizedType) || !MetadataReader.class.isAssignableFrom((Class)(rawType = (ptype = (ParameterizedType)type).getRawType())) || (ret = MetadataReaderUtils.getTypeParameterClass((Class)rawType)) == null) continue;
                    return ret;
                }
            }
        }
        return null;
    }
}

