/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TableObjectReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.util.List;

public abstract class IndexReader
extends TableObjectReader<Index> {
    public static final String INDEX_TYPE = "index_type";
    public static final String PCT_FREE = "pct_free";
    public static final String FILL_FACTOR = "fill_factor";
    private String indexName = null;

    protected IndexReader(Dialect dialect) {
        super(dialect);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public void loadFull(Connection connection, Table table) {
        Index obj;
        int i;
        List list = this.getAllFull(connection);
        int size = list.size();
        IndexCollection c = this.getSchemaObjectList(table);
        UniqueConstraint uc = table.getConstraints().getPrimaryKeyConstraint();
        for (i = 0; i < size; ++i) {
            obj = (Index)list.get(i);
            if (!obj.isUnique() || this.isPrimaryKey(uc, obj)) continue;
            c.add(obj);
        }
        for (i = 0; i < size; ++i) {
            obj = (Index)list.get(i);
            if (obj.isUnique() || this.isPrimaryKey(uc, obj)) continue;
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, Table table) {
        Index obj;
        int i;
        List list = this.getAll(connection);
        int size = list.size();
        IndexCollection c = this.getSchemaObjectList(table);
        UniqueConstraint uc = table.getConstraints().getPrimaryKeyConstraint();
        for (i = 0; i < size; ++i) {
            obj = (Index)list.get(i);
            if (!obj.isUnique() || this.isPrimaryKey(uc, obj)) continue;
            c.add(obj);
        }
        for (i = 0; i < size; ++i) {
            obj = (Index)list.get(i);
            if (obj.isUnique() || this.isPrimaryKey(uc, obj)) continue;
            c.add(obj);
        }
    }

    private boolean isPrimaryKey(UniqueConstraint uc, Index obj) {
        return uc != null && !CommonUtils.eqIgnoreCase(uc.getName(), obj.getName()) && uc.isPrimaryKey();
    }

    @Override
    protected TripleKeyMap<String, String, String, List<Index>> toKeyMap(List<Index> list) {
        TripleKeyMap<String, String, String, List<Index>> map = new TripleKeyMap<String, String, String, List<Index>>();
        for (Index obj : list) {
            List<Index> tableConsts = map.get(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName());
            if (tableConsts == null) {
                tableConsts = CommonUtils.list();
                map.put(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName(), tableConsts);
            }
            tableConsts.add(obj);
        }
        return map;
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName(), this.getSchemaName());
        this.setTableName(context, this.nativeCaseString(connection, this.getObjectName()));
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getIndexName()));
        return context;
    }

    @Override
    protected String getNameLabel() {
        return SchemaProperties.INDEX_NAME.getLabel();
    }

    protected IndexCollection getSchemaObjectList(Table table) {
        return table.getIndexes();
    }
}

