/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.OperatorClassReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.FunctionFamily;
import com.sqlapp.data.schemas.OperatorClass;
import java.sql.Connection;
import java.util.List;

public abstract class FunctionFamilyReader
extends MetadataReader<FunctionFamily, OperatorClass> {
    protected static final String OPERATOR_CLASS_NAME = "operator_class_name";
    private String objectName = null;
    private String schemaName = null;

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public FunctionFamilyReader setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected FunctionFamilyReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    public void loadFull(Connection connection, OperatorClass target) {
        ParametersContext context = this.defaultParametersContext(connection);
        List<FunctionFamily> list = this.getAll(connection, context);
        OperatorClassReader.addFunctionFamilies(list, target);
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName(), this.getSchemaName());
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getObjectName()));
        return context;
    }

    protected String getNameLabel() {
        return DbObjects.OPERATOR_CLASS.getCamelCaseNameLabel();
    }

    protected String getObjectName(ParametersContext context) {
        return (String)context.get(this.getNameLabel());
    }
}

