/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TableObjectReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.util.List;

public abstract class ConstraintReader<T extends Constraint>
extends TableObjectReader<T> {
    protected static final String UPDATE_RULE = "update_rule";
    protected static final String DELETE_RULE = "delete_rule";
    protected static final String MATCH_OPTION = "match_option";
    protected static final String DEFERRABILITY = "deferrability";
    private String constraintName = null;

    protected ConstraintReader(Dialect dialect) {
        super(dialect);
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @Override
    public void loadFull(Connection connection, Table table) {
        List list = this.getAllFull(connection);
        int size = list.size();
        ConstraintCollection c = this.getSchemaObjectList(table);
        for (int i = 0; i < size; ++i) {
            Constraint obj = (Constraint)list.get(i);
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, Table table) {
        List list = this.getAll(connection);
        int size = list.size();
        ConstraintCollection c = this.getSchemaObjectList(table);
        for (int i = 0; i < size; ++i) {
            Constraint obj = (Constraint)list.get(i);
            c.add(obj);
        }
    }

    @Override
    protected TripleKeyMap<String, String, String, List<T>> toKeyMap(List<T> list) {
        TripleKeyMap<String, String, String, List<String>> map = new TripleKeyMap<String, String, String, List<String>>();
        for (Constraint obj : list) {
            List<T> tableConsts = map.get(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName());
            if (tableConsts == null) {
                tableConsts = CommonUtils.list();
                map.put(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName(), tableConsts);
            }
            tableConsts.add(obj);
        }
        return map;
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName(), this.getSchemaName());
        this.setTableName(context, this.nativeCaseString(connection, this.getObjectName()));
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getConstraintName()));
        return context;
    }

    @Override
    protected String getNameLabel() {
        return "constraintName";
    }

    protected ConstraintCollection getSchemaObjectList(Table table) {
        return table.getConstraints();
    }
}

