/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.TableObjectReader;
import com.sqlapp.data.db.metadata.TypeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.util.List;

public abstract class ColumnReader
extends TableObjectReader<Column> {
    private String columnName = null;

    protected ColumnReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    public void loadFull(Connection connection, Table table) {
        List list = this.getAllFull(connection);
        int size = list.size();
        ColumnCollection c = this.getSchemaObjectList(table);
        for (int i = 0; i < size; ++i) {
            Column obj = (Column)list.get(i);
            this.initialize(obj);
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, Table table) {
        List list = this.getAll(connection);
        int size = list.size();
        ColumnCollection c = this.getSchemaObjectList(table);
        for (int i = 0; i < size; ++i) {
            Column obj = (Column)list.get(i);
            this.initialize(obj);
            c.add(obj);
        }
    }

    @Override
    protected void doGetAllAfter(Connection connection, List<Column> list) {
        TripleKeyMap<String, String, String, Domain> tkDomainMap = CommonUtils.tripleKeyMap();
        TripleKeyMap<String, String, String, Type> tkTypeMap = CommonUtils.tripleKeyMap();
        SchemaReader schemaReader = (SchemaReader)((MetadataReader)this.getParent()).getParent();
        DomainReader domainReader = schemaReader.getDomainReader();
        TypeReader typeReader = schemaReader.getTypeReader();
        if (domainReader != null) {
            List domains = domainReader.getAllFull(connection);
            for (Domain domain : domains) {
                tkDomainMap.put(domain.getCatalogName(), domain.getSchemaName(), domain.getName(), domain);
            }
        }
        if (typeReader != null) {
            List types = typeReader.getAllFull(connection);
            for (Type type : types) {
                tkTypeMap.put(type.getCatalogName(), type.getSchemaName(), type.getName(), type);
            }
        }
        for (Column column : list) {
            Domain domain;
            if (column.getDataType() != DataType.OTHER) continue;
            domain = (Domain)tkDomainMap.get(column.getCatalogName(), column.getSchemaName(), column.getDataTypeName());
            if (domain != null) {
                column.setDataType(DataType.DOMAIN);
                continue;
            }
            Type type = (Type)tkTypeMap.get(column.getCatalogName(), column.getSchemaName(), column.getDataTypeName());
            if (type != null) {
                column.setDataType(DataType.STRUCT);
                continue;
            }
            logger.info("Unsupported dbTypeName=" + column.getDataTypeName() + ", column=" + column);
        }
    }

    @Override
    protected TripleKeyMap<String, String, String, List<Column>> toKeyMap(List<Column> list) {
        TripleKeyMap<String, String, String, List<Column>> map = new TripleKeyMap<String, String, String, List<Column>>();
        for (Column obj : list) {
            List<Column> tableConsts = map.get(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName());
            if (tableConsts == null) {
                tableConsts = CommonUtils.list();
                map.put(obj.getCatalogName(), obj.getSchemaName(), obj.getTableName(), tableConsts);
            }
            tableConsts.add(obj);
        }
        return map;
    }

    protected ColumnCollection getSchemaObjectList(Table table) {
        return table.getColumns();
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName(), this.getSchemaName());
        this.setTableName(context, this.nativeCaseString(connection, this.getObjectName()));
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getColumnName()));
        context.put("containsHiddenColumns", (Object)this.getReaderOptions().isContainsHiddenColumns());
        return context;
    }

    @Override
    protected String getNameLabel() {
        return SchemaProperties.COLUMN_NAME.getLabel();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    protected String getColumnName(ParametersContext context) {
        return (String)context.get(this.getNameLabel());
    }

    protected Column createColumn(String name) {
        Column column = new Column(name);
        column.setDialect(this.getDialect());
        return column;
    }
}

