/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.util;

import com.sqlapp.data.db.dialect.util.StringHolder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SqlTokenizer {
    private String delimiter = ";";
    private String currentDelimiter = null;
    protected StringHolder stringHolder;
    private boolean comment = false;
    private TreeMap<Integer, TextMarker> textMarkers = new TreeMap();

    public SqlTokenizer(String original) {
        this.stringHolder = new StringHolder(original);
        this.preParse(this.stringHolder);
        this.currentDelimiter = null;
    }

    protected void preParse(StringHolder stringHolder) {
        if (!(stringHolder = stringHolder.clone()).hasNext()) {
            // empty if block
        }
        while (stringHolder.hasNext()) {
            int pos = stringHolder.getLineEnd();
            String text = stringHolder.getLine();
            if (this.isChangeDelimiter(text, stringHolder)) continue;
            if (this.isLineComment(text)) {
                TextMarker marker = new TextMarker();
                marker.setStart(stringHolder.getPosition());
                marker.setEnd(pos);
                marker.setValue(text);
                marker.setType(Type.SINGLE_LINE_COMMENT);
                this.addTextMarker(marker);
                stringHolder.setPosition(pos + 1);
                continue;
            }
            if (this.isStartMultiLineComment(text, stringHolder)) {
                int commStart = stringHolder.searchFirstElement("/*");
                stringHolder.setPosition(commStart);
                int commEnd = stringHolder.indexOf("*/");
                if (commEnd >= 0) {
                    TextMarker marker = new TextMarker();
                    marker.setStart(commStart);
                    marker.setEnd(commEnd += 2);
                    marker.setValue(stringHolder.substringAt(commEnd));
                    marker.setType(Type.MULTI_LINE_COMMENT);
                    this.addTextMarker(marker);
                    stringHolder.setPosition(commEnd);
                    continue;
                }
                stringHolder.throwInvalidTextException("[*/] not found.");
                continue;
            }
            QuoteHolder quoteHolderMax = this.getQuoteHolder(stringHolder);
            if (quoteHolderMax.position >= 0) {
                StringHolder clone = stringHolder.clone();
                clone.setPosition(quoteHolderMax.position);
                clone.addPosition(quoteHolderMax.quote.length());
                int endPos = clone.searchEndQuote("'", "''");
                if (endPos >= 0) {
                    TextMarker marker = new TextMarker();
                    stringHolder.setPosition(quoteHolderMax.position);
                    marker.setStart(quoteHolderMax.position);
                    marker.setEnd(endPos);
                    marker.setValue(stringHolder.substringAt(endPos + 1));
                    marker.setType(Type.QUOTED_STRING);
                    this.addTextMarker(marker);
                    stringHolder.setPosition(endPos + 1);
                    continue;
                }
                stringHolder.throwInvalidTextException("['] end quote not found.");
                continue;
            }
            stringHolder.nextLine();
        }
    }

    protected QuoteHolder getQuoteHolder(StringHolder stringHolder) {
        return this.getQuoteHolder(stringHolder, "N'", "B'", "'");
    }

    protected QuoteHolder getQuoteHolder(StringHolder stringHolder, String ... args) {
        List quoteHolders = CommonUtils.list();
        for (String arg : args) {
            QuoteHolder quoteHolder = this.searchQuote(stringHolder, arg);
            quoteHolders.add(quoteHolder);
        }
        QuoteHolder quoteHolder = (QuoteHolder)quoteHolders.get(0);
        for (int i = 1; i < quoteHolders.size(); ++i) {
            quoteHolder = quoteHolder.max((QuoteHolder)quoteHolders.get(i));
        }
        return quoteHolder;
    }

    private QuoteHolder searchQuote(StringHolder stringHolder, String quote) {
        int quotePos = stringHolder.searchStartQuote(quote);
        QuoteHolder holder = new QuoteHolder(quote, quotePos);
        return holder;
    }

    protected TextMarker getTextMarker(int position) {
        TextMarker marker;
        Map.Entry<Integer, TextMarker> entry = this.textMarkers.floorEntry(position);
        if (entry != null && (marker = entry.getValue()).match(position)) {
            return marker;
        }
        entry = this.textMarkers.ceilingEntry(position);
        if (entry != null && (marker = entry.getValue()).match(position)) {
            return marker;
        }
        return null;
    }

    private void addTextMarker(TextMarker marker) {
        this.textMarkers.put(marker.getStart(), marker);
    }

    public boolean hasNext() {
        if (!this.stringHolder.hasNext()) {
            return false;
        }
        int pos = this.stringHolder.getLineEnd();
        if (pos >= 0) {
            String text = this.stringHolder.getLine();
            this.comment = false;
            if (this.isChangeDelimiter(text, this.stringHolder)) {
                return this.hasNext();
            }
            if (text.trim().length() == 0) {
                this.stringHolder.setCurrent(text);
                this.stringHolder.nextLine();
                return this.hasNext();
            }
            TextMarker textMarker = this.getTextMarker(this.stringHolder.getPosition());
            if (textMarker != null && textMarker.getType().isComment()) {
                this.comment = true;
                this.stringHolder.setCurrent(textMarker.getValue());
                this.stringHolder.setPosition(textMarker.getEnd());
                return true;
            }
            if (this.isStatementDelimiter(text, this.stringHolder)) {
                return true;
            }
            if (this.isStartStatement(text, this.stringHolder)) {
                return true;
            }
            this.handleElse(this.stringHolder);
            return true;
        }
        this.stringHolder.setPosition(this.stringHolder.getContextLength() + 1);
        return false;
    }

    protected void setPosition(int pos) {
        if (pos >= 0) {
            this.stringHolder.setCurrent(this.stringHolder.substringAt(pos));
            this.stringHolder.setPosition(pos + 1);
        } else {
            pos = this.stringHolder.getContextLength();
            String value = this.stringHolder.substringAt(pos);
            this.stringHolder.setPosition(pos);
            this.stringHolder.setCurrent(value);
        }
    }

    protected void handleElse(StringHolder stringHolder) {
        int delPos = this.searchDelimiter();
        if (delPos >= 0) {
            this.handleSimpleStatement(delPos, stringHolder);
        } else {
            this.setPosition(delPos);
        }
    }

    protected int searchDelimiter() {
        int pos;
        int start = this.stringHolder.getPosition();
        while ((pos = this.stringHolder.indexOf(this.getCurrentDelimiter(), start)) >= 0) {
            TextMarker textMarker = this.getTextMarker(pos);
            if (textMarker == null) {
                return pos;
            }
            start = textMarker.getEnd();
        }
        return pos;
    }

    public boolean isComment() {
        return this.comment;
    }

    protected void handleSimpleStatement(int delPos, StringHolder stringHolder) {
        String value = stringHolder.substringAt(delPos);
        stringHolder.setPosition(delPos + this.getCurrentDelimiter().length() + 1);
        stringHolder.setCurrent(value);
    }

    protected boolean isLineComment(String text) {
        return text.trim().startsWith("--");
    }

    private boolean isStartMultiLineComment(String text, StringHolder stringHolder) {
        int pos = stringHolder.searchFirstElement("/*");
        if (pos >= 0) {
            StringHolder clone = stringHolder.clone();
            clone.setPosition(pos);
            int commEnd = clone.indexOf("*/");
            if (commEnd >= 0) {
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean isChangeDelimiter(String text, StringHolder stringHolder) {
        return false;
    }

    protected boolean isStartStatement(String text, StringHolder stringHolder) {
        return false;
    }

    protected boolean isStatementDelimiter(String text, StringHolder stringHolder) {
        return false;
    }

    protected String getCurrentDelimiter() {
        if (this.currentDelimiter == null) {
            return this.getDelimiter();
        }
        return this.currentDelimiter;
    }

    protected void setCurrentDelimiter(String currentDelimiter) {
        this.currentDelimiter = currentDelimiter;
    }

    protected String getDelimiter() {
        return this.delimiter;
    }

    protected void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String next() {
        return this.stringHolder.getCurrent();
    }

    static enum Type {
        QUOTED_STRING,
        MULTI_LINE_COMMENT{

            @Override
            public boolean isComment() {
                return true;
            }
        }
        ,
        SINGLE_LINE_COMMENT{

            @Override
            public boolean isComment() {
                return true;
            }
        };


        public boolean isBlank() {
            return false;
        }

        public boolean isComment() {
            return false;
        }
    }

    public static class TextMarker {
        private int start;
        private int end;
        private Type type;
        private String value;

        public boolean match(int position) {
            return this.start <= position && position < this.end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextMarker)) {
                return false;
            }
            TextMarker other = (TextMarker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            if (this.getEnd() != other.getEnd()) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TextMarker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStart();
            result = result * 59 + this.getEnd();
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "SqlTokenizer.TextMarker(start=" + this.getStart() + ", end=" + this.getEnd() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
        }
    }

    static class QuoteHolder {
        public String quote;
        public int position;

        public QuoteHolder() {
        }

        public QuoteHolder(String quote, int position) {
            this.position = position;
            this.quote = quote;
        }

        QuoteHolder max(QuoteHolder holder) {
            if (this.position >= 0) {
                if (this.position < holder.position) {
                    return this;
                }
                if (holder.position >= 0) {
                    return holder;
                }
            } else {
                if (holder.position > 0) {
                    return holder;
                }
                return this;
            }
            return this;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder();
            builder.add("quote", this.quote);
            builder.add("position", this.position);
            return builder.toString();
        }
    }
}

