/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlTokenizer;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlSplitter {
    private Dialect dialect;
    protected List<SplitResult> statements = null;
    private static Pattern TERMINATE_PATTERN = Pattern.compile("(.*);$", 40);

    public SqlSplitter() {
        this.dialect = null;
    }

    public SqlSplitter(Dialect dialect) {
        this.dialect = dialect;
    }

    public List<SplitResult> parse(String input) {
        this.statements = CommonUtils.list();
        this.parse(this.createSqlTokenizer(input));
        return this.statements;
    }

    protected List<SplitResult> getStatements() {
        return this.statements;
    }

    protected SqlTokenizer createSqlTokenizer(String input) {
        return new SqlTokenizer(input);
    }

    protected void parse(SqlTokenizer sqlTokenizer) {
        while (sqlTokenizer.hasNext()) {
            String line = this.getResult(sqlTokenizer);
            if (CommonUtils.isEmpty(line)) continue;
            SplitResult splitResult = new SplitResult(this.getTextType(sqlTokenizer.isComment(), line), line);
            this.getStatements().add(splitResult);
            this.addStatementAfter();
        }
    }

    protected void addStatementAfter() {
    }

    protected TextType getTextType(boolean isComment, String sql) {
        if (isComment) {
            return TextType.COMMENT;
        }
        return TextType.SQL;
    }

    protected String getResult(SqlTokenizer sqlTokenizer) {
        String line = sqlTokenizer.next();
        if (CommonUtils.isEmpty(line)) {
            return line;
        }
        String val = CommonUtils.rtrim(line);
        Matcher matcher = TERMINATE_PATTERN.matcher(val);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return val;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    public static enum TextType {
        COMMENT{

            @Override
            public boolean isComment() {
                return true;
            }
        }
        ,
        COMMENT_DIRECTIVE{

            @Override
            public boolean isComment() {
                return true;
            }
        }
        ,
        SQL;


        public boolean isComment() {
            return false;
        }
    }

    public static class SplitResult {
        private TextType textType;
        private String text;

        public SplitResult(TextType textType, String text) {
            this.textType = textType;
            this.text = text;
        }

        public TextType getTextType() {
            return this.textType;
        }

        public void setTextType(TextType textType) {
            this.textType = textType;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder("");
            builder.add("textType", (Object)this.textType);
            builder.add("text", this.text);
            return builder.toString();
        }
    }
}

