/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcColumnReader;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcMetadataUtils;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class JdbcViewReader
extends ViewReader {
    private String[] tableTypes = new String[]{"VIEW"};

    public JdbcViewReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected ColumnReader newColumnReader() {
        return new JdbcColumnReader(this.getDialect());
    }

    @Override
    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        try {
            return JdbcMetadataUtils.getMetadata(connection, CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())), this.tableTypes);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IndexReader newIndexReader() {
        return null;
    }

    @Override
    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

