/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcColumnReader;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcForeignKeyConstraintReader;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcIndexReader;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcMetadataUtils;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcPrimaryKeyConstraintReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class JdbcTableReader
extends TableReader {
    private String[] tableTypes = new String[]{"TABLE", "SYSTEM TABLE"};

    public JdbcTableReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        try {
            return JdbcMetadataUtils.getMetadata(connection, CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())), this.getTableType());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void setFilter(List<Table> tableList, ParametersContext context) {
        Set catalogNames = CommonUtils.treeSet();
        Set schemaNames = CommonUtils.treeSet();
        Set tableNames = CommonUtils.treeSet();
        for (Table table : tableList) {
            if (table.getCatalogName() != null) {
                catalogNames.add(table.getCatalogName());
            }
            if (table.getSchemaName() != null) {
                schemaNames.add(table.getSchemaName());
            }
            if (table.getName() == null) continue;
            tableNames.add(table.getName());
        }
        if (catalogNames.size() == 1) {
            context.put("catalogName", (Object)catalogNames);
        }
        if (schemaNames.size() == 1) {
            context.put("schemaName", (Object)schemaNames);
        }
        if (tableNames.size() == 1) {
            context.put("tableName", (Object)tableNames);
        }
    }

    protected String[] getTableType() {
        return this.tableTypes;
    }

    @Override
    protected ColumnReader newColumnReader() {
        return new JdbcColumnReader(this.getDialect());
    }

    @Override
    protected IndexReader newIndexReader() {
        return new JdbcIndexReader(this.getDialect());
    }

    @Override
    protected UniqueConstraintReader newUniqueConstraintReader() {
        return new JdbcPrimaryKeyConstraintReader(this.getDialect());
    }

    @Override
    protected CheckConstraintReader newCheckConstraintReader() {
        return null;
    }

    @Override
    protected ForeignKeyConstraintReader newForeignKeyConstraintReader() {
        return new JdbcForeignKeyConstraintReader(this.getDialect());
    }

    @Override
    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

