/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPair;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcForeignKeyConstraintReader
extends ForeignKeyConstraintReader {
    public JdbcForeignKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<ForeignKeyConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<ForeignKeyConstraint> list;
        ResultSet rs = null;
        List<ForeignKeyConstraint> list2 = CommonUtils.list();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getImportedKeys(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.emptyToNull(this.getTableName(context)));
            TripleKeyMap<String, String, String, ForeignKeyConstraint> tCMap = CommonUtils.tripleKeyMap();
            TripleKeyMap<String, String, String, FlexList<ColumnPair>> tColMap = CommonUtils.tripleKeyMap();
            while (rs.next()) {
                String pk_table_catalog = this.getString(rs, "PKTABLE_CAT");
                String pk_table_schema = this.getString(rs, "PKTABLE_SCHEM");
                String pk_table_name = this.getString(rs, "PKTABLE_NAME");
                String pk_columnName = this.getString(rs, "PKCOLUMN_NAME");
                String fk_table_catalog = this.getString(rs, "FKTABLE_CAT");
                String fk_table_schema = this.getString(rs, "FKTABLE_SCHEM");
                String fk_table_name = this.getString(rs, "FKTABLE_NAME");
                String fk_columnName = this.getString(rs, "FKCOLUMN_NAME");
                String fk_name = this.getString(rs, "FK_NAME");
                ForeignKeyConstraint c = (ForeignKeyConstraint)tCMap.get(pk_table_catalog, pk_table_schema, fk_name);
                FlexList<ColumnPair> colList = tColMap.get(pk_table_catalog, pk_table_schema, fk_name);
                if (c == null) {
                    c = new ForeignKeyConstraint(fk_name);
                    c.setCatalogName(pk_table_catalog);
                    c.setSchemaName(pk_table_schema);
                    c.setTableName(pk_table_name);
                    c.setUpdateRule(CascadeRule.parse(rs.getInt("UPDATE_RULE")));
                    c.setDeleteRule(CascadeRule.parse(rs.getInt("DELETE_RULE")));
                    c.setDeferrability(Deferrability.parse(rs.getInt("DEFERRABILITY")));
                    colList = new FlexList();
                    tCMap.put(pk_table_catalog, pk_table_schema, fk_name, c);
                    tColMap.put(pk_table_catalog, pk_table_schema, fk_name, colList);
                    list2.add(c);
                }
                ColumnPair cPair = new ColumnPair();
                cPair.refCatalogName = fk_table_catalog;
                cPair.refSchemaName = fk_table_schema;
                cPair.refTableName = fk_table_name;
                cPair.refColumnName = fk_columnName;
                cPair.columnName = pk_columnName;
                colList.add(cPair);
            }
            this.setForeignKeyConstraintColumns(tColMap, list2);
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }
}

