/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcDomainReader
extends DomainReader {
    public JdbcDomainReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Domain> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Domain> list;
        List<Domain> result;
        ResultSet rs;
        block6: {
            rs = null;
            int[] types = new int[]{2001};
            result = CommonUtils.list();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getUDTs(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())), types);
            if (rs != null) break block6;
            List<Domain> list2 = result;
            DbUtils.close(rs);
            return list2;
        }
        try {
            while (rs.next()) {
                Domain obj = this.createDomain(rs);
                result.add(obj);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    protected Domain createDomain(ResultSet rs) throws SQLException {
        String typeName = this.getString(rs, "TYPE_NAME");
        String remarks = this.getString(rs, "REMARKS");
        int baseType = rs.getInt("BASE_TYPE");
        Domain domain = new Domain(typeName);
        domain.setCatalogName(this.getString(rs, "TYPE_CAT"));
        domain.setSchemaName(this.getString(rs, "TYPE_SCHEM"));
        domain.setRemarks(remarks);
        domain.setDataType(DataType.valueOf(baseType));
        return domain;
    }
}

