/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class JdbcColumnReader
extends ColumnReader {
    public JdbcColumnReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Column> list;
        ExResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = new ExResultSet(databaseMetaData.getColumns(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getTableName(context)), CommonUtils.emptyToNull(this.getColumnName(context))));
            List<Column> result = CommonUtils.list();
            while (rs.next()) {
                Column column = this.createColumn(rs);
                result.add(column);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    protected Column createColumn(ExResultSet rs) throws SQLException {
        String colName = this.getString(rs, "column_name");
        int sqlType = rs.getInt("DATA_TYPE");
        String productDataType = this.getString(rs, "TYPE_NAME");
        Long precision = rs.getLongValue("COLUMN_SIZE");
        Integer scale = rs.getInteger("DECIMAL_DIGITS");
        int nullable = rs.getInt("NULLABLE");
        boolean allowDBNull = false;
        if (nullable != 2 && nullable == 1) {
            allowDBNull = true;
        }
        String isAutoIncrement = this.getString(rs, "IS_AUTOINCREMENT");
        boolean autoIncrement = false;
        if ("YES".equalsIgnoreCase(isAutoIncrement) && nullable == 1) {
            autoIncrement = true;
        }
        Column column = new Column(colName);
        this.getDialect().setDbType(sqlType, productDataType, precision, scale, column);
        column.setNullable(allowDBNull);
        column.setIdentity(autoIncrement);
        column.setCatalogName(this.getString(rs, "TABLE_CAT"));
        column.setSchemaName(this.getString(rs, "TABLE_SCHEM"));
        column.setTableName(this.getString(rs, "table_name"));
        column.setDefaultValue(this.getString(rs, "COLUMN_DEF"));
        column.setOctetLength(rs.getInt("CHAR_OCTET_LENGTH"));
        return column;
    }
}

