/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcColumnPrivilegeReader;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcObjectPrivilegeReader;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcSchemaReader;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ColumnPrivilegeReader;
import com.sqlapp.data.db.metadata.ObjectPrivilegeReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractJdbcCatalogReader
extends CatalogReader {
    public AbstractJdbcCatalogReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Catalog> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Catalog> list;
        ResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getCatalogs();
            List<Catalog> result = CommonUtils.list();
            while (rs.next()) {
                Catalog obj = new Catalog(this.getString(rs, "TABLE_CAT"));
                result.add(obj);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    @Override
    protected SchemaReader newSchemaReader() {
        return new JdbcSchemaReader(this.getDialect());
    }

    @Override
    public String getCurrentCatalogName(Connection connection) {
        try {
            return connection.getCatalog();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ObjectPrivilegeReader newObjectPrivilegeReader() {
        return new JdbcObjectPrivilegeReader(this.getDialect());
    }

    @Override
    protected ColumnPrivilegeReader newColumnPrivilegeReader() {
        return new JdbcColumnPrivilegeReader(this.getDialect());
    }
}

