/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ISSequenceReader
extends SequenceReader {
    protected ISSequenceReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Sequence> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Sequence> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Sequence sequence = ISSequenceReader.this.createSequence(rs);
                result.add(sequence);
            }
        });
        return result;
    }

    protected Sequence createSequence(ExResultSet rs) throws SQLException {
        String name = this.getString(rs, "SEQUENCE_NAME");
        BigDecimal cacheSize = rs.getBigDecimal("CACHE_SIZE");
        BigDecimal lastNumber = rs.getBigDecimal("LAST_NUMBER");
        Sequence sequence = new Sequence(name);
        sequence.setCatalogName(this.getString(rs, "SEQUENCE_CATALOG"));
        sequence.setSchemaName(this.getString(rs, "SEQUENCE_SCHEMA"));
        sequence.setIncrementBy(rs.getBigDecimal("INCREMENT"));
        sequence.setMinValue(rs.getBigDecimal("MINIMUM_VALUE"));
        sequence.setMaxValue(rs.getBigDecimal("MAXIMUM_VALUE"));
        sequence.setCacheSize(cacheSize);
        sequence.setLastValue(lastNumber);
        return sequence;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(ISSequenceReader.class).getString("sequences.sql");
        return node;
    }
}

