/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ColumnPrivilege;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ISColumnPrivilegeReader
extends ColumnPrivilegeReader {
    protected ISColumnPrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<ColumnPrivilege> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<ColumnPrivilege> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                ColumnPrivilege obj = ISColumnPrivilegeReader.this.createColumnPrivilege(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected ColumnPrivilege createColumnPrivilege(ExResultSet rs) throws SQLException {
        String catalogName = this.getString(rs, "table_catalog");
        String schemaName = this.getString(rs, "table_schema");
        String objectName = this.getString(rs, "table_name");
        ColumnPrivilege obj = new ColumnPrivilege();
        obj.setCatalogName(catalogName);
        obj.setSchemaName(schemaName);
        obj.setObjectName(objectName);
        obj.setGrantorName(this.getString(rs, "GRANTOR"));
        obj.setGranteeName(this.getString(rs, "GRANTEE"));
        obj.setColumnName(this.getString(rs, "column_name"));
        obj.setPrivilege(this.getString(rs, "PRIVILEGE_TYPE"));
        obj.setGrantable("YES".equals(this.getString(rs, "IS_GRANTABLE")));
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(ISColumnPrivilegeReader.class).getString("columnPrivileges.sql");
        return node;
    }
}

