/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public abstract class AbstractISProcedureReader
extends ProcedureReader {
    protected AbstractISProcedureReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Procedure> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Procedure> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Procedure routine = AbstractISProcedureReader.this.createProcedure(rs);
                result.add(routine);
            }
        });
        return result;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(AbstractISProcedureReader.class).getString("procedures.sql");
        return node;
    }

    protected Procedure createProcedure(ExResultSet rs) throws SQLException {
        Timestamp created = rs.getTimestamp("CREATED");
        Timestamp lastAltered = rs.getTimestamp("LAST_ALTERED");
        Procedure routine = new Procedure(this.getString(rs, "ROUTINE_NAME"));
        routine.setSpecificName(this.getString(rs, "SPECIFIC_NAME"));
        routine.setCatalogName(this.getString(rs, "ROUTINE_CATALOG"));
        routine.setSchemaName(this.getString(rs, "ROUTINE_SCHEMA"));
        routine.setCreatedAt(created);
        routine.setLastAlteredAt(lastAltered);
        routine.setDefinition(this.getString(rs, "ROUTINE_DEFINITION"));
        return routine;
    }
}

